/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty.server.servlet;

import jakarta.websocket.server.ServerContainer;

public class JettyWebSocketInitializer {
    private Long idleTimeout;
    private Long asyncSendTimeout;
    private Integer maxBinaryMessageSize;
    private Integer maxTextMessageSize;

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Long getAsyncSendTimeout() {
        return this.asyncSendTimeout;
    }

    public void setAsyncSendTimeout(long asyncSendTimeout) {
        this.asyncSendTimeout = asyncSendTimeout;
    }

    public Integer getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public void setMaxBinaryMessageSize(int maxBinaryMessageSize) {
        this.maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public Integer getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public void setMaxTextMessageSize(int maxTextMessageSize) {
        this.maxTextMessageSize = maxTextMessageSize;
    }

    public void customize(ServerContainer serverContainer) {
        if (this.idleTimeout != null) {
            serverContainer.setDefaultMaxSessionIdleTimeout(this.idleTimeout.longValue());
        }
        if (this.asyncSendTimeout != null) {
            serverContainer.setAsyncSendTimeout(this.asyncSendTimeout.longValue());
        }
        if (this.maxBinaryMessageSize != null) {
            serverContainer.setDefaultMaxBinaryMessageBufferSize(this.maxBinaryMessageSize.intValue());
        }
        if (this.maxTextMessageSize != null) {
            serverContainer.setDefaultMaxTextMessageBufferSize(this.maxTextMessageSize.intValue());
        }
    }
}

