/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty.shell.command;

import com.aspectran.core.component.bean.BeanException;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.jetty.server.JettyServer;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.net.BindException;

public class JettyCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "jetty";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public JettyCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("server").valueName("name").withEqualSign().desc("ID of bean that defined Jetty server").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.setTitle("Available commands:");
        arguments.put("start", "Start Jetty server");
        arguments.put("stop", "Stop Jetty server");
        arguments.put("restart", "Restart Jetty server");
        arguments.put("status", "Display a brief status report");
        arguments.setRequired(true);
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        block17: {
            block16: {
                if (!options.hasOptions() && !options.hasArgs()) {
                    this.printQuickHelp(console);
                    return;
                }
                if (options.hasOption("help")) {
                    this.printHelp(console);
                    return;
                }
                String command = null;
                if (options.hasArgs()) {
                    command = options.getFirstArg();
                }
                String serverName = options.getValue("server", "jetty.server");
                if (command == null) break block16;
                switch (command) {
                    case "start": {
                        this.startJettyServer(serverName, console);
                        break;
                    }
                    case "stop": {
                        this.stopJettyServer(serverName, console);
                        break;
                    }
                    case "restart": {
                        if (this.stopJettyServer(serverName, console)) {
                            this.startJettyServer(serverName, console);
                            break;
                        }
                        break block17;
                    }
                    case "status": {
                        this.printServerStatus(serverName, console);
                        break;
                    }
                    default: {
                        console.writeError("Unknown command '" + String.join((CharSequence)" ", options.getArgs()) + "'");
                        this.printQuickHelp(console);
                        break;
                    }
                }
                break block17;
            }
            this.printQuickHelp(console);
        }
    }

    private void startJettyServer(String serverName, ShellConsole console) throws Exception {
        JettyServer jettyServer = null;
        try {
            if (this.hasJettyServer(serverName)) {
                jettyServer = this.getJettyServer(serverName);
                if (jettyServer.isRunning()) {
                    console.writeError("Jetty server is already running");
                } else {
                    jettyServer.start();
                    this.printStatus(jettyServer.getState(), console);
                }
            } else {
                jettyServer = this.getJettyServer(serverName);
                if (!jettyServer.isRunning()) {
                    jettyServer.start();
                }
                this.printStatus(jettyServer.getState(), console);
            }
        }
        catch (BeanException e) {
            console.writeError("Jetty server is not available. Cause: " + String.valueOf(e));
        }
        catch (Exception e) {
            Throwable cause;
            if (jettyServer != null) {
                this.destroyJettyServer(jettyServer);
            }
            if ((cause = ExceptionUtils.getRootCause(e)) instanceof BindException) {
                console.writeError("Jetty server failed to start. Cause: Port already in use");
            }
            console.writeError(e.toString());
        }
    }

    private boolean stopJettyServer(String serverName, ShellConsole console) {
        boolean success = false;
        try {
            if (this.hasJettyServer(serverName)) {
                JettyServer jettyServer = this.getJettyServer(serverName);
                this.destroyJettyServer(jettyServer);
                this.printStatus("STOPPED", console);
                success = true;
            } else {
                console.writeError("Jetty server is not running");
            }
        }
        catch (BeanException e) {
            console.writeError("Jetty server is not available. Cause: " + String.valueOf(e));
        }
        catch (Exception e) {
            console.writeError(e.toString());
        }
        return success;
    }

    private void printServerStatus(String serverName, ShellConsole console) {
        try {
            if (this.hasJettyServer(serverName)) {
                JettyServer jettyServer = this.getJettyServer(serverName);
                if (jettyServer.isStarted()) {
                    this.printStatus("RUNNING", console);
                } else {
                    this.printStatus(jettyServer.getState(), console);
                }
            } else {
                this.printStatus("STOPPED", console);
            }
        }
        catch (BeanException e) {
            console.writeError("Jetty server is not available. Cause: " + String.valueOf(e));
        }
        catch (Exception e) {
            console.writeError(e.toString());
        }
    }

    private void printStatus(@NonNull String status, @NonNull ShellConsole console) {
        console.writeLine("----------------------------------------------------------------------------");
        console.setStyle("YELLOW");
        console.write(status);
        console.resetStyle();
        console.writeLine(" - Jetty " + JettyServer.getVersion());
        console.writeLine("----------------------------------------------------------------------------");
    }

    private JettyServer getJettyServer(String serverName) {
        BeanRegistry beanRegistry = this.getActiveShellService().getActivityContext().getBeanRegistry();
        return beanRegistry.getBean(JettyServer.class, serverName);
    }

    private boolean hasJettyServer(String serverName) {
        BeanRegistry beanRegistry = this.getActiveShellService().getActivityContext().getBeanRegistry();
        return beanRegistry.hasSingleton(JettyServer.class, serverName);
    }

    private void destroyJettyServer(JettyServer jettyServer) throws Exception {
        BeanRegistry beanRegistry = this.getActiveShellService().getActivityContext().getBeanRegistry();
        beanRegistry.destroySingleton(jettyServer);
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return JettyCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return JettyCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Use the command 'jetty' to control the Jetty server";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

