/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.mybatis;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.utils.Assert;
import com.aspectran.utils.ResourceUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

@AvoidAdvice
public class SqlSessionFactoryBean
implements ApplicationAdapterAware,
InitializableBean,
FactoryBean<SqlSessionFactory> {
    private ApplicationAdapter applicationAdapter;
    private String configLocation;
    private String environment;
    private Properties properties;
    private SqlSessionFactory sqlSessionFactory;

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected SqlSessionFactory buildSqlSessionFactory(InputStream inputStream) {
        try {
            SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new SqlSessionFactoryBuilder();
            return sqlSessionFactoryBuilder.build(inputStream, this.environment, this.properties);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to parse mybatis config resource: " + this.configLocation, ex);
        }
    }

    @Override
    public void setApplicationAdapter(@NonNull ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
    }

    @Override
    public void initialize() throws Exception {
        Assert.state(this.applicationAdapter != null, "No ApplicationAdapter injected");
        if (this.sqlSessionFactory == null) {
            if (this.configLocation == null) {
                throw new IllegalArgumentException("Property 'configLocation' is required");
            }
            InputStream is = this.configLocation.startsWith("classpath:") ? ResourceUtils.getResourceAsStream(this.configLocation.substring("classpath:".length())) : new FileInputStream(this.applicationAdapter.toRealPathAsFile(this.configLocation));
            this.sqlSessionFactory = this.buildSqlSessionFactory(is);
        }
    }

    @Override
    public SqlSessionFactory getObject() {
        return this.sqlSessionFactory;
    }
}

