/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.pebble;

import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.utils.LocaleUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.loader.ClasspathLoader;
import io.pebbletemplates.pebble.loader.DelegatingLoader;
import io.pebbletemplates.pebble.loader.FileLoader;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.loader.StringLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class PebbleEngineFactory
implements ActivityContextAware {
    private static final Logger logger = LoggerFactory.getLogger(PebbleEngineFactory.class);
    private ActivityContext context;
    private Locale defaultLocale;
    private boolean strictVariables;
    private String[] templateLoaderPaths;
    private Loader<?>[] templateLoaders;

    @Override
    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.context = context;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = LocaleUtils.parseLocaleString(defaultLocale);
    }

    public void setStrictVariables(boolean strictVariables) {
        this.strictVariables = strictVariables;
    }

    public void setTemplateLoaderPath(String templateLoaderPath) {
        this.templateLoaderPaths = new String[]{templateLoaderPath};
    }

    public void setTemplateLoaderPath(String[] templateLoaderPaths) {
        this.templateLoaderPaths = templateLoaderPaths;
    }

    public void setTemplateLoaderPath(@NonNull List<String> templateLoaderPathList) {
        this.templateLoaderPaths = templateLoaderPathList.toArray(new String[0]);
    }

    public void setTemplateLoader(Loader<?> templateLoaders) {
        this.templateLoaders = new Loader[]{templateLoaders};
    }

    public void setTemplateLoader(Loader<?>[] templateLoaders) {
        this.templateLoaders = templateLoaders;
    }

    public void setTemplateLoader(@NonNull List<Loader<?>> templateLoaderList) {
        this.templateLoaders = templateLoaderList.toArray(new Loader[0]);
    }

    public PebbleEngine createPebbleEngine() {
        PebbleEngine.Builder builder = new PebbleEngine.Builder();
        builder.strictVariables(this.strictVariables);
        if (this.defaultLocale != null) {
            builder.defaultLocale(this.defaultLocale);
        }
        if (this.templateLoaders == null && this.templateLoaderPaths != null && this.templateLoaderPaths.length > 0) {
            ArrayList templateLoaderList = new ArrayList();
            for (String path : this.templateLoaderPaths) {
                templateLoaderList.add(this.getTemplateLoaderForPath(path));
            }
            this.setTemplateLoader(templateLoaderList);
        }
        Loader<?> templateLoader = this.getAggregateTemplateLoader(this.templateLoaders);
        builder.loader(templateLoader);
        return builder.build();
    }

    protected Loader<?> getAggregateTemplateLoader(Loader<?>[] templateLoaders) {
        int loaderCount = templateLoaders == null ? 0 : templateLoaders.length;
        switch (loaderCount) {
            case 0: {
                StringLoader stringLoader = new StringLoader();
                if (logger.isDebugEnabled()) {
                    logger.debug("Pebble Engine Template Loader not specified. Default Template Loader registered: " + String.valueOf(stringLoader));
                }
                return stringLoader;
            }
            case 1: {
                if (logger.isDebugEnabled()) {
                    logger.debug("One Pebble Engine Template Loader registered: " + String.valueOf(templateLoaders[0]));
                }
                return templateLoaders[0];
            }
        }
        ArrayList<StringLoader> defaultLoadingStrategies = new ArrayList<StringLoader>();
        defaultLoadingStrategies.add(new StringLoader());
        Collections.addAll(defaultLoadingStrategies, templateLoaders);
        DelegatingLoader delegatingLoader = new DelegatingLoader(defaultLoadingStrategies);
        if (logger.isDebugEnabled()) {
            logger.debug("Multiple Pebble Engine Template Loader registered: " + String.valueOf(delegatingLoader));
        }
        return delegatingLoader;
    }

    protected Loader<?> getTemplateLoaderForPath(@NonNull String templateLoaderPath) {
        if (templateLoaderPath.startsWith("classpath:")) {
            String basePackagePath = templateLoaderPath.substring("classpath:".length());
            if (logger.isDebugEnabled()) {
                logger.debug("Template loader path [" + templateLoaderPath + "] resolved to class path [" + basePackagePath + "]");
            }
            ClasspathLoader loader = new ClasspathLoader(this.context.getAvailableActivity().getClassLoader());
            loader.setPrefix(basePackagePath);
            return loader;
        }
        if (templateLoaderPath.startsWith("file:")) {
            File file = new File(templateLoaderPath.substring("file:".length()));
            String prefix = file.getAbsolutePath();
            if (logger.isDebugEnabled()) {
                logger.debug("Template loader path [" + templateLoaderPath + "] resolved to file path [" + prefix + "]");
            }
            FileLoader loader = new FileLoader();
            loader.setPrefix(prefix);
            return loader;
        }
        File file = new File(this.context.getApplicationAdapter().getBasePath(), templateLoaderPath);
        String prefix = file.getAbsolutePath();
        if (logger.isDebugEnabled()) {
            logger.debug("Template loader path [" + templateLoaderPath + "] resolved to file path [" + prefix + "]");
        }
        FileLoader loader = new FileLoader();
        loader.setPrefix(prefix);
        return loader;
    }
}

