/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.pebble;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityData;
import com.aspectran.core.component.template.engine.TemplateEngine;
import com.aspectran.core.component.template.engine.TemplateEngineProcessException;
import com.aspectran.utils.Assert;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class PebbleTemplateEngine
implements TemplateEngine {
    private final PebbleEngine pebbleEngine;

    public PebbleTemplateEngine(PebbleEngine pebbleEngine) {
        Assert.notNull((Object)pebbleEngine, "pebbleEngine must not be null");
        this.pebbleEngine = pebbleEngine;
    }

    public PebbleEngine getPebbleEngine() {
        return this.pebbleEngine;
    }

    @Override
    public void process(String templateName, Activity activity) throws TemplateEngineProcessException {
        this.checkHasEngine();
        try {
            PebbleTemplateEngine.process(this.pebbleEngine, templateName, activity);
            activity.getResponseAdapter().getWriter().flush();
        }
        catch (Exception e) {
            throw new TemplateEngineProcessException(e);
        }
    }

    @Override
    public void process(String templateSource, String contentType, Activity activity) throws TemplateEngineProcessException {
        this.checkHasEngine();
        try {
            PebbleTemplateEngine.processLiteral(this.pebbleEngine, templateSource, activity);
            activity.getResponseAdapter().getWriter().flush();
        }
        catch (Exception e) {
            throw new TemplateEngineProcessException(e);
        }
    }

    public static void process(PebbleEngine pebbleEngine, String templateName, Activity activity) throws IOException {
        Assert.notNull((Object)pebbleEngine, "pebbleEngine must not be null");
        Assert.notNull((Object)templateName, "templateName must not be null");
        Assert.notNull((Object)activity, "activity must not be null");
        Locale locale = activity.getRequestAdapter().getLocale();
        ActivityData variables = activity.getActivityData();
        Writer writer = activity.getResponseAdapter().getWriter();
        PebbleTemplate compiledTemplate = pebbleEngine.getTemplate(templateName);
        compiledTemplate.evaluate(writer, (Map)variables, locale);
    }

    private static void processLiteral(PebbleEngine pebbleEngine, String templateSource, Activity activity) throws IOException {
        Assert.notNull((Object)pebbleEngine, "pebbleEngine must not be null");
        Assert.notNull((Object)templateSource, "templateName must not be null");
        Assert.notNull((Object)activity, "activity must not be null");
        Locale locale = activity.getRequestAdapter().getLocale();
        ActivityData variables = activity.getActivityData();
        Writer writer = activity.getResponseAdapter().getWriter();
        PebbleTemplate compiledTemplate = pebbleEngine.getLiteralTemplate(templateSource);
        compiledTemplate.evaluate(writer, (Map)variables, locale);
    }

    private void checkHasEngine() {
        if (this.pebbleEngine == null) {
            throw new IllegalStateException("PebbleEngine not specified");
        }
    }
}

