/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.pebble.view;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.dispatch.AbstractViewDispatcher;
import com.aspectran.core.activity.response.dispatch.ViewDispatcherException;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.pebble.PebbleTemplateEngine;
import com.aspectran.utils.Assert;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import io.pebbletemplates.pebble.PebbleEngine;

public class PebbleViewDispatcher
extends AbstractViewDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(PebbleViewDispatcher.class);
    private final PebbleEngine pebbleEngine;

    public PebbleViewDispatcher(PebbleTemplateEngine pebbleTemplateEngine) {
        Assert.notNull((Object)pebbleTemplateEngine, "pebbleTemplateEngine must not be null");
        this.pebbleEngine = pebbleTemplateEngine.getPebbleEngine();
    }

    public PebbleViewDispatcher(PebbleEngine pebbleEngine) {
        Assert.notNull((Object)pebbleEngine, "pebbleEngine must not be null");
        this.pebbleEngine = pebbleEngine;
    }

    @Override
    public void dispatch(Activity activity, DispatchRule dispatchRule) throws ViewDispatcherException {
        String viewName = null;
        try {
            String encoding;
            viewName = this.resolveViewName(dispatchRule, activity);
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            String contentType = dispatchRule.getContentType();
            if (contentType == null) {
                contentType = this.getContentType();
            }
            if (contentType != null) {
                responseAdapter.setContentType(contentType);
            }
            if ((encoding = dispatchRule.getEncoding()) == null && responseAdapter.getEncoding() == null) {
                encoding = activity.getTranslet().getDefinitiveResponseEncoding();
            }
            if (encoding != null) {
                responseAdapter.setEncoding(encoding);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Dispatching to Pebble template [" + viewName + "]");
            }
            PebbleTemplateEngine.process(this.pebbleEngine, viewName, activity);
        }
        catch (Exception e) {
            activity.setRaisedException(e);
            throw new ViewDispatcherException("Failed to dispatch to Pebble template " + dispatchRule.toString(this, viewName), e);
        }
    }
}

