/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.shell.command.DefaultConsoleCommander;
import com.aspectran.shell.console.DefaultShellConsole;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.InsufficientEnvironmentException;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.File;

public class AspectranShell {
    public static void main(String[] args) {
        String basePath = AspectranConfig.determineBasePath(args);
        File aspectranConfigFile = AspectranConfig.determineAspectranConfigFile(args);
        AspectranShell.bootstrap(basePath, aspectranConfigFile);
    }

    public static void bootstrap(File aspectranConfigFile) {
        AspectranShell.bootstrap(null, aspectranConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bootstrap(@Nullable String basePath, File aspectranConfigFile) {
        if (aspectranConfigFile == null) {
            throw new IllegalArgumentException("aspectranConfigFile must not be null");
        }
        DefaultConsoleCommander commander = null;
        int exitStatus = 0;
        try {
            DefaultShellConsole console = new DefaultShellConsole();
            commander = new DefaultConsoleCommander(console);
            commander.configure(basePath, aspectranConfigFile);
            commander.run();
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause(e);
            if (cause instanceof InsufficientEnvironmentException) {
                InsufficientEnvironmentException that = (InsufficientEnvironmentException)cause;
                System.err.println(that.getPrettyMessage());
            } else {
                System.err.println(cause.getMessage());
                e.printStackTrace(System.err);
            }
            exitStatus = 1;
        }
        finally {
            if (commander != null) {
                commander.release();
            }
        }
        System.exit(exitStatus);
    }
}

