/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.MissingMandatoryAttributesException;
import com.aspectran.core.activity.request.MissingMandatoryParametersException;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.adapter.DefaultSessionAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.shell.adapter.ShellRequestAdapter;
import com.aspectran.shell.adapter.ShellResponseAdapter;
import com.aspectran.shell.command.TransletPreProcedure;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.ShellService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.OutputStringWriter;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.Writer;

public class ShellActivity
extends CoreActivity {
    private final ShellService shellService;
    private final ShellConsole console;
    private boolean procedural;
    private boolean verbose;
    private String requestName;
    private MethodType requestMethod;
    private ParameterMap parameterMap;
    private Writer outputWriter;
    private boolean async;
    private Long timeout;

    public ShellActivity(@NonNull ShellService shellService) {
        super(shellService.getActivityContext());
        this.shellService = shellService;
        this.console = shellService.getConsole();
    }

    @Override
    public Activity.Mode getMode() {
        return Activity.Mode.SHELL;
    }

    public boolean isProcedural() {
        return this.procedural;
    }

    public void setProcedural(boolean procedural) {
        this.procedural = procedural;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public MethodType getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(MethodType requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getFullRequestName() {
        if (this.requestMethod != null && this.requestName != null) {
            return String.valueOf((Object)this.requestMethod) + " " + this.requestName;
        }
        if (this.requestName != null) {
            return this.requestName;
        }
        return "";
    }

    public ParameterMap getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Writer getOutputWriter() {
        return this.outputWriter;
    }

    public void setOutputWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public boolean isAsync() {
        return this.async;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void prepare() throws TransletNotFoundException, ActivityPrepareException {
        Assert.state(this.requestName != null, "requestName is not set");
        Assert.state(this.requestMethod != null, "requestMethod is not set");
        this.prepare(this.requestName, this.requestMethod);
    }

    @Override
    protected void prepare(String requestName, MethodType requestMethod, @NonNull TransletRule transletRule) throws ActivityPrepareException {
        this.async = transletRule.isAsync();
        this.timeout = transletRule.getTimeout();
        super.prepare(requestName, requestMethod, transletRule);
    }

    public void preProcedure() throws AdapterException, RequestParseException, ActivityTerminatedException {
        this.adapt();
        this.parseRequest();
    }

    @Override
    protected void adapt() throws AdapterException {
        try {
            this.setSessionAdapter(this.shellService.newSessionAdapter());
            ShellRequestAdapter requestAdapter = new ShellRequestAdapter(this.getTranslet().getRequestMethod());
            requestAdapter.setEncoding(this.console.getEncoding());
            if (this.getParameterMap() != null) {
                requestAdapter.setParameterMap(this.getParameterMap());
            }
            this.setRequestAdapter(requestAdapter);
            Writer outputWriter = this.getOutputWriter() != null ? this.getOutputWriter() : new OutputStringWriter();
            ShellResponseAdapter responseAdapter = new ShellResponseAdapter(this.console, outputWriter);
            responseAdapter.setEncoding(this.console.getEncoding());
            this.setResponseAdapter(responseAdapter);
        }
        catch (Exception e) {
            throw new AdapterException("Failed to adapt for the shell activity", e);
        }
        super.adapt();
    }

    @Override
    protected void parseRequest() throws RequestParseException, ActivityTerminatedException {
        TransletPreProcedure procedure = new TransletPreProcedure(this.console, this.getTransletRule(), this.getParameterMap(), this.isProcedural());
        procedure.printDescription(this);
        try {
            procedure.proceed();
            super.parseRequest();
        }
        catch (MissingMandatoryParametersException e) {
            procedure.printSomeMandatoryParametersMissing(e.getItemRules());
            this.terminate("Some mandatory parameters are missing");
        }
        catch (MissingMandatoryAttributesException e) {
            procedure.printSomeMandatoryAttributesMissing(e.getItemRules());
            this.terminate("Some mandatory attributes are missing");
        }
    }

    @Override
    protected void saveCurrentActivity() {
        SessionAdapter sessionAdapter;
        super.saveCurrentActivity();
        if (!this.hasParentActivity() && (sessionAdapter = this.getSessionAdapter()) instanceof DefaultSessionAdapter) {
            DefaultSessionAdapter sessionAdapter2 = (DefaultSessionAdapter)sessionAdapter;
            sessionAdapter2.getSessionAgent().access();
        }
    }

    @Override
    protected void removeCurrentActivity() {
        SessionAdapter sessionAdapter;
        if (!this.hasParentActivity() && (sessionAdapter = this.getSessionAdapter()) instanceof DefaultSessionAdapter) {
            DefaultSessionAdapter sessionAdapter2 = (DefaultSessionAdapter)sessionAdapter;
            sessionAdapter2.getSessionAgent().complete();
        }
        super.removeCurrentActivity();
    }
}

