/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.ConsoleCommander;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.HelpFormatter;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.Options;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.ShellService;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCommand
implements Command {
    private final CommandRegistry registry;
    private final Options options = new Options();
    private final List<Arguments> argumentsList = new ArrayList<Arguments>();

    public AbstractCommand(CommandRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Command registry must not be null");
        }
        this.registry = registry;
    }

    public CommandRegistry getCommandRegistry() {
        return this.registry;
    }

    public ConsoleCommander getCommandRunner() {
        return this.registry.getConsoleCommander();
    }

    public ShellService getShellService() {
        ShellService shellService;
        ShellService shellService2 = shellService = this.getCommandRunner() != null ? this.getCommandRunner().getShellService() : null;
        if (shellService == null) {
            throw new IllegalStateException("SERVICE NOT AVAILABLE");
        }
        return shellService;
    }

    public ShellService getActiveShellService() {
        ShellService shellService = this.getShellService();
        if (!shellService.getServiceLifeCycle().isActive()) {
            throw new IllegalStateException("SERVICE NOT AVAILABLE");
        }
        return shellService;
    }

    public boolean isServiceAvailable() {
        return this.getCommandRunner() != null && this.getCommandRunner().getShellService() != null && this.getCommandRunner().getShellService().getServiceLifeCycle().isActive();
    }

    protected void addOption(Option option) {
        this.options.addOption(option);
    }

    protected void addArguments(Arguments arguments) {
        this.argumentsList.add(arguments);
    }

    protected Arguments touchArguments() {
        Arguments arguments = new Arguments();
        this.addArguments(arguments);
        return arguments;
    }

    protected void skipParsingAtNonOption() {
        this.options.setSkipParsingAtNonOption(true);
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public List<Arguments> getArgumentsList() {
        return this.argumentsList;
    }

    @Override
    public void printHelp(ShellConsole console) {
        if (this.getDescriptor().getDescription() != null) {
            console.writeLine(this.getDescriptor().getDescription());
        }
        this.printQuickHelp(console);
    }

    @Override
    public void printQuickHelp(ShellConsole console) {
        HelpFormatter formatter = new HelpFormatter(console);
        formatter.printHelp(this);
    }
}

