/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.Arrays;

public abstract class AbstractCommandLine {
    private static final String PARAM_NAME_PREFIX = "--";
    private final ParameterMap parameterMap = new ParameterMap();
    private final CommandLineParser lineParser;
    private boolean verbose;

    public AbstractCommandLine(@NonNull CommandLineParser lineParser) {
        this.lineParser = lineParser;
        this.parse();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public CommandLineParser getLineParser() {
        return this.lineParser;
    }

    public String getRequestName() {
        return this.lineParser.getCommandName();
    }

    public ParameterMap getParameterMap() {
        return this.parameterMap;
    }

    protected void parse() {
        if (this.lineParser.getCommandName() != null) {
            this.extractParameterMap();
        }
    }

    private void extractParameterMap() {
        if (!this.lineParser.hasArgs()) {
            return;
        }
        String name = null;
        for (String arg : this.lineParser.getArgs()) {
            if (arg.startsWith(PARAM_NAME_PREFIX)) {
                name = arg.substring(PARAM_NAME_PREFIX.length());
                int index = name.indexOf(61);
                if (index == 0) {
                    name = null;
                    continue;
                }
                if (index > 0) {
                    String value = name.substring(index + 1);
                    String[] values = this.parameterMap.getParameterValues(name = name.substring(0, index));
                    if (values != null) {
                        values = Arrays.copyOf(values, values.length + 1);
                        values[values.length - 1] = value;
                    } else {
                        values = new String[]{value};
                    }
                    this.parameterMap.setParameterValues(name, values);
                    name = null;
                    continue;
                }
                this.parameterMap.setParameterValues(name, null);
                continue;
            }
            if (name == null) continue;
            String[] values = this.parameterMap.getParameterValues(name);
            if (values != null) {
                values = Arrays.copyOf(values, values.length + 1);
                values[values.length - 1] = arg;
            } else {
                values = new String[]{arg};
            }
            this.parameterMap.setParameterValues(name, values);
            name = null;
        }
    }
}

