/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.shell.command.OutputRedirection;
import com.aspectran.shell.command.option.DefaultOptionParser;
import com.aspectran.shell.command.option.OptionParserException;
import com.aspectran.shell.command.option.Options;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineParser {
    private static final Pattern ARGS_PATTERN = Pattern.compile("\\s+\"([^\"]*)\"|\"([^\"]*)\"|\\s+'([^']*)'|'([^']*)'|([^\\s\"']+)");
    private static final Pattern REDIRECTION_PATTERN = Pattern.compile("(>>)|(>)|(\")|(')");
    private static final Logger logger = LoggerFactory.getLogger(CommandLineParser.class);
    private final String commandLine;
    private String commandName;
    private String[] args;
    private List<OutputRedirection> redirectionList;

    public CommandLineParser(String commandLine) {
        this.commandLine = this.parseOutputRedirection(commandLine);
        if (StringUtils.hasLength(this.commandLine)) {
            this.args = this.splitCommandLine(this.commandLine);
        }
        this.shift();
    }

    public void shift() {
        if (this.args != null && this.args.length > 0) {
            if (!StringUtils.hasLength(this.args[0])) {
                this.shift();
            } else {
                this.commandName = this.args[0];
                this.args = this.args.length > 1 ? Arrays.copyOfRange(this.args, 1, this.args.length) : new String[0];
            }
        }
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean hasArgs() {
        return this.args != null && this.args.length > 0;
    }

    public ParsedOptions parseOptions(Options options) throws OptionParserException {
        DefaultOptionParser parser = new DefaultOptionParser();
        return parser.parse(options, this.args, options.isSkipParsingAtNonOption());
    }

    public List<OutputRedirection> getRedirectionList() {
        return this.redirectionList;
    }

    @NonNull
    private String[] splitCommandLine(String commandLine) {
        ArrayList<Object> list = new ArrayList<Object>();
        Matcher m = ARGS_PATTERN.matcher(commandLine);
        while (m.find()) {
            int index;
            if (m.group(1) != null) {
                list.add(m.group(1));
                continue;
            }
            if (m.group(2) != null) {
                if (!list.isEmpty()) {
                    index = list.size() - 1;
                    list.set(index, (String)list.get(index) + m.group(2));
                    continue;
                }
                list.add(m.group(2));
                continue;
            }
            if (m.group(3) != null) {
                list.add(m.group(3));
                continue;
            }
            if (m.group(4) != null) {
                if (!list.isEmpty()) {
                    index = list.size() - 1;
                    list.set(index, (String)list.get(index) + m.group(4));
                    continue;
                }
                list.add(m.group(4));
                continue;
            }
            list.add(m.group(5));
        }
        return list.toArray(new String[0]);
    }

    @Nullable
    private String parseOutputRedirection(String line) {
        if (!StringUtils.hasLength(line)) {
            return null;
        }
        String commandLine = line;
        Matcher matcher = REDIRECTION_PATTERN.matcher(line);
        ArrayList<OutputRedirection> redirectionList = new ArrayList<OutputRedirection>();
        OutputRedirection prevRedirection = null;
        boolean hasDoubleQuote = false;
        boolean hasSingleQuote = false;
        while (matcher.find()) {
            String str;
            if (matcher.group(1) != null && !hasDoubleQuote && !hasSingleQuote) {
                str = line.substring(0, matcher.start(1)).trim();
                if (prevRedirection != null) {
                    prevRedirection.setOperand(this.stripQuotes(str));
                } else {
                    commandLine = str;
                }
                prevRedirection = new OutputRedirection(OutputRedirection.Operator.APPEND_OUT);
                redirectionList.add(prevRedirection);
                line = line.substring(matcher.end(1));
                matcher = REDIRECTION_PATTERN.matcher(line);
                continue;
            }
            if (matcher.group(2) != null && !hasDoubleQuote && !hasSingleQuote) {
                str = line.substring(0, matcher.start(2)).trim();
                if (prevRedirection != null) {
                    prevRedirection.setOperand(this.stripQuotes(str));
                } else {
                    commandLine = str;
                }
                prevRedirection = new OutputRedirection(OutputRedirection.Operator.OVERWRITE_OUT);
                redirectionList.add(prevRedirection);
                line = line.substring(matcher.end(2));
                matcher = REDIRECTION_PATTERN.matcher(line);
                continue;
            }
            if (matcher.group(3) != null) {
                hasDoubleQuote = !hasDoubleQuote;
                continue;
            }
            if (matcher.group(4) == null) continue;
            hasSingleQuote = !hasSingleQuote;
        }
        if (prevRedirection != null) {
            prevRedirection.setOperand(this.stripQuotes(line.trim()));
        }
        if (!redirectionList.isEmpty()) {
            this.redirectionList = redirectionList;
            if (logger.isDebugEnabled()) {
                logger.debug("Output Redirection: " + OutputRedirection.serialize(redirectionList));
            }
        }
        if (StringUtils.hasLength(commandLine)) {
            return commandLine;
        }
        return null;
    }

    @NonNull
    private String stripQuotes(@NonNull String str) {
        if (str.length() > 1 && (str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'"))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

