/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.Aspectran;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ShellConfig;
import com.aspectran.core.context.config.ShellStyleConfig;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.ConsoleCommander;
import com.aspectran.shell.command.OutputRedirection;
import com.aspectran.shell.command.ShellCommandRegistry;
import com.aspectran.shell.command.TransletCommandLine;
import com.aspectran.shell.command.builtins.QuitCommand;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.CommandReadFailedException;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.console.ShellConsoleClosedException;
import com.aspectran.shell.console.ShellConsoleWrapper;
import com.aspectran.shell.service.DefaultShellService;
import com.aspectran.shell.service.DefaultShellServiceBuilder;
import com.aspectran.shell.service.ShellService;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.SystemUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.File;
import java.io.IOError;
import java.io.PrintWriter;

public class DefaultConsoleCommander
implements ConsoleCommander {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConsoleCommander.class);
    private final ShellConsole console;
    private ShellCommandRegistry commandRegistry;
    private DefaultShellService shellService;

    public DefaultConsoleCommander(@NonNull ShellConsole console) {
        this.console = console;
    }

    @Override
    public <T extends ShellConsole> T getConsole() {
        return (T)this.console;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public ShellService getShellService() {
        return this.shellService;
    }

    protected void consoleReady() {
        Aspectran.printPrettyAboutMe(this.console.getOutput());
        this.console.getOutput().flush();
    }

    public void configure(@Nullable String basePath, @NonNull File aspectranConfigFile) throws Exception {
        String historyFile;
        String commandPrompt;
        ShellConfig shellConfig;
        ShellStyleConfig shellStyleConfig;
        AspectranConfig aspectranConfig;
        try {
            aspectranConfig = new AspectranConfig(aspectranConfigFile);
        }
        catch (AponParseException e) {
            throw new IllegalArgumentException("Failed to parse aspectran config file: " + String.valueOf(aspectranConfigFile), e);
        }
        if (StringUtils.hasText(basePath)) {
            aspectranConfig.touchContextConfig().setBasePath(basePath);
        }
        if ((shellStyleConfig = (shellConfig = aspectranConfig.touchShellConfig()).getShellStyleConfig()) != null) {
            this.console.setShellStyleConfig(shellStyleConfig);
        }
        if ((commandPrompt = shellConfig.getPrompt()) != null) {
            this.console.setCommandPrompt(commandPrompt);
        }
        if (StringUtils.hasLength(historyFile = shellConfig.getHistoryFile())) {
            historyFile = StringUtils.hasText(basePath) ? new File(basePath, historyFile).getCanonicalPath() : new File(historyFile).getCanonicalPath();
            this.console.setCommandHistoryFile(historyFile);
        }
        this.consoleReady();
        if (aspectranConfig.hasContextConfig()) {
            this.shellService = DefaultShellServiceBuilder.build(aspectranConfig, this.console);
            this.shellService.start();
            File workingDir = this.determineWorkingDir();
            this.console.setWorkingDir(workingDir);
        } else {
            String greetings = shellConfig.getGreetings();
            if (StringUtils.hasText(greetings)) {
                this.console.writeLine(greetings);
            }
        }
        this.commandRegistry = new ShellCommandRegistry(this);
        this.commandRegistry.addCommand(shellConfig.getCommands());
        if (this.commandRegistry.getCommand(QuitCommand.class) == null) {
            this.commandRegistry.addCommand(QuitCommand.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.console.setConsoleCommander(this);
            while (true) {
                try {
                    while (true) {
                        CommandLineParser lineParser;
                        String commandLine;
                        if (!StringUtils.hasLength(commandLine = this.console.readCommandLine()) || (lineParser = new CommandLineParser(commandLine)).getCommandName() == null) {
                            continue;
                        }
                        Command command = null;
                        if (this.commandRegistry != null) {
                            command = this.commandRegistry.getCommand(lineParser.getCommandName());
                        }
                        if (command != null) {
                            this.execute(command, lineParser);
                            continue;
                        }
                        if (this.shellService != null) {
                            TransletCommandLine transletCommandLine = new TransletCommandLine(lineParser);
                            this.execute(transletCommandLine);
                            continue;
                        }
                        this.console.writeLine("No command mapped to '" + lineParser.getCommandName() + "'");
                    }
                }
                catch (ShellConsoleClosedException e) {
                    if (StringUtils.hasText(e.getMessage())) {
                        this.console.writeLine(e.getMessage());
                    }
                }
                catch (CommandReadFailedException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Command read failed", e.getCause());
                    continue;
                }
                catch (IOError e) {
                    this.console.clearLine();
                }
                catch (Throwable e) {
                    logger.error("Error executing shell command", e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.console.setConsoleCommander(null);
            if (logger.isDebugEnabled() && this.shellService != null && this.shellService.isActive()) {
                logger.debug("Do not terminate this application while releasing all resources");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Command command, CommandLineParser lineParser) {
        ShellConsoleWrapper wrappedConsole = new ShellConsoleWrapper(this.console);
        try (PrintWriter outputWriter = null;){
            ParsedOptions options = lineParser.parseOptions(command.getOptions());
            outputWriter = OutputRedirection.determineOutputWriter(lineParser.getRedirectionList(), wrappedConsole);
            wrappedConsole.setWriter(outputWriter);
            command.execute(options, wrappedConsole);
        }
    }

    private void execute(TransletCommandLine transletCommandLine) {
        if (this.shellService == null) {
            throw new IllegalStateException("Shell service not available");
        }
        if (transletCommandLine.getRequestName() != null) {
            try {
                this.shellService.translate(transletCommandLine);
            }
            catch (TransletNotFoundException e) {
                this.console.writeError("No command or translet mapped to '" + e.getTransletName() + "'");
            }
            catch (ShellConsoleClosedException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Failed to execute command: " + transletCommandLine.getLineParser().getCommandLine(), e);
            }
        } else {
            this.console.writeError("No command or translet mapped to '" + transletCommandLine.getLineParser().getCommandLine() + "'");
        }
    }

    public void release() {
        if (this.shellService != null) {
            this.shellService.stop();
            this.shellService = null;
        }
    }

    @Nullable
    private File determineWorkingDir() {
        String workPath = SystemUtils.getProperty("aspectran.workPath");
        if (StringUtils.hasText(workPath)) {
            return new File(workPath);
        }
        return null;
    }
}

