/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.activity.request.MissingMandatoryParametersException;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.shell.activity.ShellActivity;
import com.aspectran.shell.console.PromptStringBuilder;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TransletPreProcedure {
    private final ShellConsole console;
    private final TransletRule transletRule;
    private final ParameterMap parameterMap;
    private final boolean procedural;
    private boolean readSimply;

    public TransletPreProcedure(@NonNull ShellConsole console, @NonNull TransletRule transletRule, @NonNull ParameterMap parameterMap, boolean procedural) {
        this.console = console;
        this.transletRule = transletRule;
        this.parameterMap = parameterMap;
        this.procedural = procedural;
    }

    public void proceed() throws MissingMandatoryParametersException {
        this.determineSimpleReading();
        if (this.procedural) {
            this.printRequiredParameters();
            this.printRequiredAttributes();
        }
        this.readRequiredParameters();
    }

    private void determineSimpleReading() {
        ItemRuleMap parameterItemRuleMap;
        ItemRuleMap attributeItemRuleMap = this.transletRule.getRequestRule().getAttributeItemRuleMap();
        this.readSimply = attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty() ? false : ((parameterItemRuleMap = this.transletRule.getRequestRule().getParameterItemRuleMap()) != null && !parameterItemRuleMap.isEmpty() ? this.isSimpleItemRules(parameterItemRuleMap.values()) : true);
    }

    private boolean isSimpleItemRules(@NonNull Collection<ItemRule> itemRules) {
        for (ItemRule itemRule : itemRules) {
            if (itemRule.getType() != ItemType.SINGLE) {
                return false;
            }
            Token[] tokens = itemRule.getAllTokens();
            if (tokens == null || tokens.length <= 0) continue;
            if (tokens.length == 1) {
                Token token = tokens[0];
                if (token.getType() == TokenType.TEXT || token.getType() == TokenType.PARAMETER && token.getName().equals(itemRule.getName())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void printDescription(String description) {
        if (description != null) {
            this.console.infoStyle();
            this.console.writeLine(description);
            this.console.resetStyle();
        }
    }

    public void printDescription(@NonNull ShellActivity activity) {
        DescriptionRule descriptionRule;
        if (activity.isVerbose() && (descriptionRule = this.transletRule.getDescriptionRule()) != null) {
            this.printDescription(DescriptionRule.render(descriptionRule, activity));
        }
    }

    private void printRequiredParameters() {
        ItemRuleMap parameterItemRuleMap = this.transletRule.getRequestRule().getParameterItemRuleMap();
        if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
            this.console.secondaryStyle();
            this.console.writeLine("Required parameters:");
            this.console.resetStyle();
            if (!this.readSimply) {
                this.writeItems(parameterItemRuleMap.values(), TokenType.PARAMETER);
            }
        }
    }

    private void printRequiredAttributes() {
        ItemRuleMap attributeItemRuleMap;
        if (!this.readSimply && (attributeItemRuleMap = this.transletRule.getRequestRule().getAttributeItemRuleMap()) != null && !attributeItemRuleMap.isEmpty()) {
            this.console.secondaryStyle();
            this.console.writeLine("Required attributes:");
            this.console.resetStyle();
            this.writeItems(attributeItemRuleMap.values(), TokenType.ATTRIBUTE);
        }
    }

    public void printSomeMandatoryParametersMissing(Collection<ItemRule> itemRules) {
        if (itemRules != null && !itemRules.isEmpty()) {
            this.console.dangerStyle();
            this.console.writeLine("Some mandatory parameters are missing:");
            for (ItemRule ir : itemRules) {
                this.console.warningStyle();
                this.console.write(" * ");
                this.console.resetStyle("bold");
                this.console.writeLine(ir.getName());
            }
            this.console.resetStyle();
        }
    }

    public void printSomeMandatoryAttributesMissing(Collection<ItemRule> itemRules) {
        if (itemRules != null && !itemRules.isEmpty()) {
            this.console.dangerStyle();
            this.console.writeLine("Some mandatory attributes are missing:");
            for (ItemRule ir : itemRules) {
                this.console.warningStyle();
                this.console.write(" * ");
                this.console.resetStyle("bold");
                this.console.writeLine(ir.getName());
            }
            this.console.resetStyle();
        }
    }

    private void readRequiredParameters() throws MissingMandatoryParametersException {
        ItemRuleMap parameterItemRuleMap = this.transletRule.getRequestRule().getParameterItemRuleMap();
        if (parameterItemRuleMap == null || parameterItemRuleMap.isEmpty()) {
            return;
        }
        Collection<ItemRule> itemRules = parameterItemRuleMap.values();
        Collection<ItemRule> missingItemRules = this.procedural ? (this.readSimply ? this.readEachParameter(itemRules) : this.readEachToken(itemRules)) : this.checkRequiredParameters(itemRules);
        if (missingItemRules != null) {
            Collection<ItemRule> missingItemRules2;
            this.console.warningStyle();
            this.console.writeLine("Missing mandatory parameters:");
            this.console.resetStyle();
            if (!this.readSimply) {
                this.writeItems(missingItemRules, TokenType.PARAMETER);
            }
            if ((missingItemRules2 = this.readSimply ? this.readEachParameter(missingItemRules) : this.readEachToken(missingItemRules)) != null) {
                throw new MissingMandatoryParametersException(missingItemRules2);
            }
        }
    }

    @Nullable
    private Collection<ItemRule> readEachParameter(@NonNull Collection<ItemRule> itemRules) {
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        for (ItemRule ir : itemRules) {
            if (ir.hasOnlyFixedValue()) continue;
            String value = this.readParameter(ir);
            if (StringUtils.hasLength(value)) {
                this.parameterMap.setParameter(ir.getName(), value);
                continue;
            }
            if (!ir.isMandatory()) continue;
            missingItemRules.add(ir);
        }
        return missingItemRules.isEmpty() ? null : missingItemRules;
    }

    private String readParameter(@NonNull ItemRule itemRule) {
        PromptStringBuilder psb = this.console.newPromptStringBuilder().warningStyle().append(this.getMandatoryMarker(itemRule.isMandatory())).resetStyle("bold").append(itemRule.getName()).resetStyle().append(": ");
        Token[] tokens = itemRule.getAllTokens();
        if (tokens != null && tokens.length == 1) {
            Token token = tokens[0];
            if (token.getType() == TokenType.TEXT) {
                psb.defaultValue(token.getDefaultValue());
            } else if (token.getType() == TokenType.PARAMETER && token.getName().equals(itemRule.getName())) {
                psb.defaultValue(token.getDefaultValue());
            }
        }
        if (itemRule.isSecret()) {
            return this.console.readPassword(psb);
        }
        return this.console.readLine(psb);
    }

    @Nullable
    private Collection<ItemRule> readEachToken(@NonNull Collection<ItemRule> itemRules) {
        this.console.secondaryStyle();
        this.console.writeLine("Enter a value for each token:");
        this.console.resetStyle();
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        LinkedHashMap valueTokens = new LinkedHashMap();
        for (ItemRule itemRule : itemRules) {
            if (itemRule.hasOnlyFixedValue()) continue;
            Token[] tokens = itemRule.getAllTokens();
            if (tokens == null || tokens.length == 0) {
                Token token = new Token(TokenType.PARAMETER, itemRule.getName());
                tokens = new Token[]{token};
            }
            for (Token t1 : tokens) {
                Set<ItemRule> rules;
                if (t1.getType() != TokenType.PARAMETER) continue;
                boolean exists = false;
                for (Token t2 : valueTokens.keySet()) {
                    if (!t2.equals(t1)) continue;
                    exists = true;
                    break;
                }
                if (exists) {
                    rules = (Set)valueTokens.get(t1);
                    rules.add(itemRule);
                    continue;
                }
                rules = new LinkedHashSet();
                rules.add(itemRule);
                valueTokens.put(t1, rules);
            }
        }
        for (Map.Entry entry : valueTokens.entrySet()) {
            Token token = (Token)entry.getKey();
            Set set = (Set)entry.getValue();
            boolean secret = this.hasSecretItem(set);
            PromptStringBuilder psb = this.console.newPromptStringBuilder().append("   ").infoStyle().append(String.valueOf('$')).append(String.valueOf('{')).resetStyle("bold").append(token.getName()).infoStyle().append(String.valueOf('}')).resetStyle().append(": ").defaultValue(token.getDefaultValue());
            String line = secret ? this.console.readPassword(psb) : this.console.readLine(psb);
            if (StringUtils.hasLength(line)) {
                this.parameterMap.setParameter(token.getName(), line);
                continue;
            }
            for (ItemRule ir : set) {
                if (!ir.isMandatory()) continue;
                missingItemRules.add(ir);
            }
        }
        return missingItemRules.isEmpty() ? null : missingItemRules;
    }

    private boolean hasSecretItem(@NonNull Collection<ItemRule> itemRules) {
        boolean secret = false;
        for (ItemRule ir : itemRules) {
            if (!ir.isSecret()) continue;
            secret = true;
            break;
        }
        return secret;
    }

    @NonNull
    private String getMandatoryMarker(boolean mandatory) {
        return mandatory ? " * " : "   ";
    }

    private void writeItems(@NonNull Collection<ItemRule> itemRules, TokenType tokenType) {
        for (ItemRule itemRule : itemRules) {
            if (this.readSimply) {
                this.writeItem(itemRule, null);
                continue;
            }
            Token[] tokens = itemRule.getAllTokens();
            if (tokens == null) {
                Token t = new Token(tokenType, itemRule.getName());
                tokens = new Token[]{t};
            }
            this.writeItem(itemRule, tokens);
        }
    }

    private void writeItem(@NonNull ItemRule itemRule, Token[] tokens) {
        this.console.warningStyle();
        this.console.write(this.getMandatoryMarker(itemRule.isMandatory()));
        this.console.resetStyle("bold");
        this.console.write(itemRule.getName());
        this.console.resetStyle();
        if (tokens != null && tokens.length > 0) {
            this.console.write(": ");
            if (itemRule.isSecret()) {
                this.console.write(StringUtils.repeat('*', 8));
            } else {
                for (Token token : tokens) {
                    this.writeToken(token);
                }
            }
        }
        this.console.writeLine();
    }

    private void writeToken(@NonNull Token token) {
        if (token.getType() == TokenType.TEXT) {
            this.console.write(token.stringify());
        } else {
            String str = token.stringify();
            this.console.infoStyle();
            this.console.write(str.substring(0, 2));
            this.console.resetStyle("bold");
            this.console.write(str.substring(2, str.length() - 1));
            this.console.infoStyle();
            this.console.write(str.substring(str.length() - 1));
            this.console.resetStyle();
        }
    }

    @Nullable
    private Collection<ItemRule> checkRequiredParameters(@NonNull Collection<ItemRule> itemRules) {
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        for (ItemRule itemRule : itemRules) {
            String[] values = this.parameterMap.getParameterValues(itemRule.getName());
            if (values != null && values.length != 0) continue;
            missingItemRules.add(itemRule);
        }
        return missingItemRules.isEmpty() ? null : missingItemRules;
    }
}

