/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.converter.RulesToParameters;
import com.aspectran.core.context.rule.params.AspectParameters;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.ShellService;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class AspectCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "aspect";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public AspectCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("l").longName("list").hasValues().optionalValue().valueName("keywords").desc("Print list of all aspects or those filtered by given keywords").build());
        this.addOption(Option.builder("d").longName("detail").hasValues().optionalValue().valueName("aspect_id").desc("Print detailed information for the aspect").build());
        this.addOption(Option.builder("enable").hasValues().valueName("aspect_id").desc("Enable an aspect with a given name").build());
        this.addOption(Option.builder("disable").hasValues().valueName("aspect_id").desc("Disable an aspect with a given name").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        ShellService shellService = this.getActiveShellService();
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasOption("list")) {
            String[] keywords = options.getValues("list");
            this.listAspects(shellService, console, keywords);
        } else if (options.hasOption("detail")) {
            String[] aspectIds = options.getValues("detail");
            this.describeAspectRule(shellService, console, aspectIds);
        } else if (options.hasOption("enable")) {
            String[] aspectIds = options.getValues("enable");
            this.changeAspectActiveState(shellService, console, aspectIds, false);
        } else if (options.hasOption("disable")) {
            String[] aspectIds = options.getValues("disable");
            this.changeAspectActiveState(shellService, console, aspectIds, true);
        } else {
            this.printQuickHelp(console);
        }
    }

    private void listAspects(@NonNull ShellService shellService, @NonNull ShellConsole console, String[] keywords) {
        AspectRuleRegistry aspectRuleRegistry = shellService.getActivityContext().getAspectRuleRegistry();
        Collection<AspectRule> aspectRules = aspectRuleRegistry.getAspectRules();
        console.writeLine("-%4s-+-%-46s-+-%-8s-+-%-7s-", "----", "----------------------------------------------", "--------", "-------");
        console.writeLine(" %4s | %-46s | %-8s | %-7s ", "No.", "Aspect ID", "Isolated", "Enabled");
        console.writeLine("-%4s-+-%-46s-+-%-8s-+-%-7s-", "----", "----------------------------------------------", "--------", "-------");
        int num = 0;
        for (AspectRule aspectRule : aspectRules) {
            if (keywords != null) {
                boolean exists = false;
                for (String keyw : keywords) {
                    if (!aspectRule.getId().toLowerCase().contains(keyw.toLowerCase())) continue;
                    exists = true;
                    break;
                }
                if (!exists) continue;
            }
            console.write("%5d | %-46s ", ++num, aspectRule.getId());
            console.write("|");
            if (aspectRule.isIsolated()) {
                console.successStyle();
            }
            console.write(" %-8s ", aspectRule.isIsolated());
            if (aspectRule.isIsolated()) {
                console.resetStyle();
            }
            console.write("|");
            if (!aspectRule.isDisabled()) {
                console.successStyle();
            }
            console.writeLine(" %-7s ", !aspectRule.isDisabled());
            if (aspectRule.isDisabled()) continue;
            console.resetStyle();
        }
        if (num == 0) {
            console.writeLine("%31s %s", " ", "- No Data -");
        }
        console.writeLine("-%4s-+-%-46s-+-%-8s-+-%-7s-", "----", "----------------------------------------------", "--------", "-------");
    }

    private void describeAspectRule(@NonNull ShellService shellService, @NonNull ShellConsole console, String[] aspectIds) throws IOException {
        Collection<AspectRule> aspectRules;
        AspectRuleRegistry aspectRuleRegistry = shellService.getActivityContext().getAspectRuleRegistry();
        if (aspectIds == null || aspectIds.length == 0) {
            aspectRules = aspectRuleRegistry.getAspectRules();
        } else {
            aspectRules = new ArrayList<AspectRule>();
            for (String aspectId : aspectIds) {
                AspectRule aspectRule = aspectRuleRegistry.getAspectRule(aspectId);
                if (aspectRule == null) {
                    try {
                        int num = Integer.parseInt(aspectId) - 1;
                        aspectRule = aspectRuleRegistry.getAspectRules().toArray(new AspectRule[0])[num];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (aspectRule == null) {
                    console.writeError("Unknown aspect: " + aspectId);
                    return;
                }
                aspectRules.add(aspectRule);
            }
        }
        int count = 0;
        for (AspectRule aspectRule : aspectRules) {
            AspectParameters aspectParameters = RulesToParameters.toAspectParameters(aspectRule);
            if (count == 0) {
                console.writeLine("----------------------------------------------------------------------------");
            }
            Object aponWriter = ((AponWriter)new AponWriter(console.getWriter()).nullWritable(false)).autoFlush(true);
            ((AponWriter)aponWriter).write(aspectParameters);
            ((AponWriter)aponWriter).flush();
            console.writeLine("----------------------------------------------------------------------------");
            ++count;
        }
    }

    private void changeAspectActiveState(@NonNull ShellService shellService, @NonNull ShellConsole console, @NonNull String[] aspectIds, boolean disabled) {
        AspectRuleRegistry aspectRuleRegistry = shellService.getActivityContext().getAspectRuleRegistry();
        ArrayList<AspectRule> aspectRules = new ArrayList<AspectRule>();
        for (String aspectId : aspectIds) {
            AspectRule aspectRule = aspectRuleRegistry.getAspectRule(aspectId);
            if (aspectRule == null) {
                console.writeError("Unknown aspect: " + aspectId);
                return;
            }
            if (aspectRule.isIsolated()) {
                console.writeError("Can not be disabled or enabled for isolated Aspect '" + aspectId + "'.");
                return;
            }
            aspectRules.add(aspectRule);
        }
        for (AspectRule aspectRule : aspectRules) {
            if (disabled) {
                if (aspectRule.isDisabled()) {
                    console.writeLine("Aspect '" + aspectRule.getId() + "' is already inactive.");
                    continue;
                }
                aspectRule.setDisabled(true);
                console.writeLine("Aspect '" + aspectRule.getId() + "' is now inactive.");
                continue;
            }
            if (!aspectRule.isDisabled()) {
                console.writeLine("Aspect '" + aspectRule.getId() + "' is already active.");
                continue;
            }
            aspectRule.setDisabled(false);
            console.writeLine("Aspect '" + aspectRule.getId() + "' is now active.");
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return AspectCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return AspectCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Shows registered aspects, disables or enables them";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

