/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;

public class ClearCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "clear";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public ClearCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else {
            console.clearScreen();
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return ClearCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return ClearCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Clears your screen if this is possible";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

