/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;

public class HistoryCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "history";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public HistoryCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("c").longName("clear").desc("Clear command history").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasOption("clear")) {
            console.clearCommandHistory();
        } else {
            this.listHistory(console);
        }
    }

    private void listHistory(ShellConsole console) {
        console.writeLine("-%4s-+-%-67s-", "----", "-------------------------------------------------------------------");
        console.writeLine(" %4s | %-67s ", "No.", "User input commands");
        console.writeLine("-%4s-+-%-67s-", "----", "-------------------------------------------------------------------");
        int num = 0;
        for (String line : console.getCommandHistory()) {
            console.writeLine("%5d | %s", ++num, line);
        }
        if (num == 0) {
            console.writeLine("%31s %s", " ", "- No Data -");
        }
        console.writeLine("-%4s-+-%-67s-", "----", "-------------------------------------------------------------------");
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return HistoryCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return HistoryCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Display or delete all previously run commands";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

