/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.converter.RulesToParameters;
import com.aspectran.core.context.rule.params.ScheduleParameters;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.ShellService;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;

public class JobCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "job";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public JobCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("l").longName("list").hasValues().optionalValue().valueName("keywords").desc("Print list of all scheduled jobs or those filtered by given keywords").build());
        this.addOption(Option.builder("d").longName("detail").hasValues().optionalValue().valueName("translet_name").desc("Print detailed information for the scheduled job").build());
        this.addOption(Option.builder("enable").hasValues().valueName("translet_name").desc("Enable a scheduled job with a given name").build());
        this.addOption(Option.builder("disable").hasValues().valueName("translet_name").desc("Disable a scheduled job with a given name").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        ShellService shellService = this.getActiveShellService();
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasOption("list")) {
            String[] keywords = options.getValues("list");
            this.listScheduledJobs(shellService, console, keywords);
        } else if (options.hasOption("detail")) {
            String[] transletNames = options.getValues("detail");
            this.describeScheduledJobRule(shellService, console, transletNames);
        } else if (options.hasOption("enable")) {
            String[] transletNames = options.getValues("enable");
            this.changeJobActiveState(shellService, console, transletNames, false);
        } else if (options.hasOption("disable")) {
            String[] transletNames = options.getValues("disable");
            this.changeJobActiveState(shellService, console, transletNames, true);
        } else {
            this.printQuickHelp(console);
        }
    }

    private void listScheduledJobs(@NonNull ShellService shellService, @NonNull ShellConsole console, String[] keywords) {
        ScheduleRuleRegistry scheduleRuleRegistry = shellService.getActivityContext().getScheduleRuleRegistry();
        console.writeLine("-%4s-+-%-20s-+-%-34s-+-%-7s-", "----", "--------------------", "----------------------------------", "-------");
        console.writeLine(" %4s | %-20s | %-34s | %-7s ", "No.", "Schedule ID", "Job Name", "Enabled");
        console.writeLine("-%4s-+-%-20s-+-%-34s-+-%-7s-", "----", "--------------------", "----------------------------------", "-------");
        int num = 0;
        for (ScheduleRule scheduleRule : scheduleRuleRegistry.getScheduleRules()) {
            for (ScheduledJobRule jobRule : scheduleRule.getScheduledJobRuleList()) {
                if (keywords != null) {
                    boolean exists = false;
                    for (String keyw : keywords) {
                        if (!jobRule.getTransletName().toLowerCase().contains(keyw.toLowerCase())) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) continue;
                }
                console.write("%5d | %-20s | %-34s |", ++num, scheduleRule.getId(), jobRule.getTransletName());
                if (!jobRule.isDisabled()) {
                    console.successStyle();
                }
                console.writeLine(" %-7s ", !jobRule.isDisabled());
                if (jobRule.isDisabled()) continue;
                console.resetStyle();
            }
        }
        if (num == 0) {
            console.writeLine("%31s %s", " ", "- No Data -");
        }
        console.writeLine("-%4s-+-%-20s-+-%-34s-+-%-7s-", "----", "--------------------", "----------------------------------", "-------");
    }

    private void describeScheduledJobRule(@NonNull ShellService shellService, @NonNull ShellConsole console, @Nullable String[] transletNames) throws IOException {
        ScheduleRuleRegistry scheduleRuleRegistry = shellService.getActivityContext().getScheduleRuleRegistry();
        if (transletNames != null && transletNames.length > 0) {
            Set<ScheduledJobRule> scheduledJobRules = scheduleRuleRegistry.getScheduledJobRules(transletNames);
            if (scheduledJobRules.isEmpty()) {
                console.writeError("Unknown scheduled job " + Arrays.toString(transletNames));
                return;
            }
            int count = 0;
            for (ScheduledJobRule jobRule : scheduledJobRules) {
                ScheduleParameters scheduleParameters = RulesToParameters.toScheduleParameters(jobRule.getScheduleRule(), jobRule);
                if (count == 0) {
                    console.writeLine("----------------------------------------------------------------------------");
                }
                Object aponWriter = ((AponWriter)new AponWriter(console.getWriter()).nullWritable(false)).autoFlush(true);
                ((AponWriter)aponWriter).write(scheduleParameters);
                ((AponWriter)aponWriter).flush();
                console.writeLine("----------------------------------------------------------------------------");
                ++count;
            }
            if (count == 0) {
                console.writeError("Unknown scheduled job " + Arrays.toString(transletNames));
            }
        } else {
            int count = 0;
            for (ScheduleRule scheduleRule : scheduleRuleRegistry.getScheduleRules()) {
                ScheduleParameters scheduleParameters = RulesToParameters.toScheduleParameters(scheduleRule);
                if (count == 0) {
                    console.writeLine("----------------------------------------------------------------------------");
                }
                Object aponWriter = ((AponWriter)new AponWriter(console.getWriter()).nullWritable(false)).autoFlush(true);
                ((AponWriter)aponWriter).write(scheduleParameters);
                ((AponWriter)aponWriter).flush();
                console.writeLine("----------------------------------------------------------------------------");
                ++count;
            }
        }
    }

    private void changeJobActiveState(@NonNull ShellService shellService, @NonNull ShellConsole console, @Nullable String[] transletNames, boolean disabled) {
        ScheduleRuleRegistry scheduleRuleRegistry = shellService.getActivityContext().getScheduleRuleRegistry();
        Set<ScheduledJobRule> scheduledJobRules = scheduleRuleRegistry.getScheduledJobRules(transletNames);
        if (scheduledJobRules.isEmpty()) {
            console.writeError("Unknown scheduled job " + Arrays.toString(transletNames));
            return;
        }
        for (ScheduledJobRule jobRule : scheduledJobRules) {
            if (disabled) {
                if (jobRule.isDisabled()) {
                    console.writeLine("Scheduled job '%s' on schedule '%s' is already inactive.", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                    continue;
                }
                jobRule.setDisabled(true);
                console.writeLine("Scheduled job '%s' on schedule '%s' is now inactive.", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                continue;
            }
            if (!jobRule.isDisabled()) {
                console.writeLine("Scheduled job '%s' on schedule '%s' is already active.", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                continue;
            }
            jobRule.setDisabled(false);
            console.writeLine("Scheduled job '%s' on schedule '%s' is now active.", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return JobCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return JobCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Shows scheduled jobs, disables or enables them";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

