/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.utils.PBEncryptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.List;

public class PBEncryptCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "encrypt";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public PBEncryptCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("p").longName("password").valueName("password").withEqualSign().desc("The password to be used for encryption").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
        this.skipParsingAtNonOption();
        Arguments arguments = this.touchArguments();
        arguments.put("<text>", "The string to encrypt");
        arguments.setRequired(true);
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        if (!options.hasOptions() && !options.hasArgs()) {
            this.printQuickHelp(console);
            return;
        }
        if (options.hasOption("help")) {
            this.printHelp(console);
            return;
        }
        String password = options.getValue("password");
        boolean implicitPassword = false;
        if (!StringUtils.hasText(password)) {
            password = PBEncryptionUtils.getPassword();
            implicitPassword = true;
        }
        if (!StringUtils.hasText(password)) {
            console.writeError("A password is required to attempt password-based encryption or decryption.");
            this.printQuickHelp(console);
            return;
        }
        List<String> inputValues = options.getArgList();
        if (inputValues.isEmpty()) {
            console.writeError("Please enter a string to decrypt.");
            this.printQuickHelp(console);
            return;
        }
        if (!implicitPassword) {
            console.writeLine("----------------------------------------------------------------------------");
            console.writeLine(" %1$9s : %2$s", "Algorithm", PBEncryptionUtils.getAlgorithm());
            console.writeLine(" %1$9s : %2$s", "Password", password);
            console.writeLine("----------------------------------------------------------------------------");
        } else {
            console.writeLine("----------------------------------------------------------------------------");
        }
        for (String input : inputValues) {
            String output;
            try {
                output = PBEncryptionUtils.encrypt(input, password);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to encrypt input string \"" + input + "\"");
            }
            console.writeLine(" %1$9s : %2$s", "Input", input);
            console.writeLine(" %1$9s : %2$s", "Result", output);
            console.writeLine("----------------------------------------------------------------------------");
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return PBEncryptCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return PBEncryptCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Encrypts the input string using the encryption password";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

