/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.ShellCommandExecutionException;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;

public class RestartCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "restart";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public RestartCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (console.confirmRestart()) {
            console.writeLine("Restarting...");
            try {
                if (this.getShellService().getServiceLifeCycle().isActive()) {
                    this.getShellService().getServiceLifeCycle().restart();
                } else {
                    this.getShellService().getServiceLifeCycle().start();
                }
            }
            catch (Exception e) {
                throw new ShellCommandExecutionException("Shell restart failed!", e);
            }
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return RestartCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return RestartCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Restarts the shell to reload all resources";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

