/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.context.resource.SiblingClassLoader;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SysInfoCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "sysinfo";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public SysInfoCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("props").longName("system-properties").desc("Displays JVM system properties").build());
        this.addOption(Option.builder("cp").longName("class-path").desc("Displays JVM classpath information").build());
        this.addOption(Option.builder("mem").longName("memory-usage").desc("Displays memory information about current JVM").build());
        this.addOption(Option.builder("gc").longName("garbage-collection").desc("Performs garbage collection").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        if (options.hasOptions()) {
            Iterator<Option> iter = options.iterator();
            HashSet<Option> done = new HashSet<Option>();
            while (iter.hasNext()) {
                Option option = iter.next();
                String name = option.getName();
                if (!done.contains(option)) {
                    if (!done.isEmpty()) {
                        console.writeLine();
                    }
                    if ("h".equals(name)) {
                        this.printHelp(console);
                    } else if ("props".equals(name)) {
                        this.printSysProperties(console);
                    } else if ("cp".equals(name)) {
                        this.printClasspath(console);
                    } else if ("mem".equals(name)) {
                        this.mem(false, console);
                    } else if ("gc".equals(name)) {
                        this.mem(true, console);
                    }
                }
                done.add(option);
            }
        } else {
            this.printSysProperties(console);
            console.writeLine();
            this.mem(false, console);
            console.writeLine();
            console.writeLine("----------------------------------------------------------------");
            this.printHelp(console);
            console.writeLine("----------------------------------------------------------------");
        }
    }

    private void printSysProperties(@NonNull ShellConsole console) {
        console.writeLine("---------------------");
        console.writeLine("JVM system properties");
        console.writeLine("---------------------");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String value = entry.getValue() != null ? this.escape(entry.getValue().toString()) : null;
            console.writeLine("%s=%s", entry.getKey(), StringUtils.nullToEmpty(value));
        }
    }

    private void printClasspath(@NonNull ShellConsole console) {
        ClassLoader classLoader;
        console.writeLine("-------------------------");
        console.writeLine("JVM classpath information");
        console.writeLine("-------------------------");
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        for (String line : StringUtils.split(bean.getClassPath(), File.pathSeparator)) {
            console.writeLine(line);
        }
        if (this.isServiceAvailable() && (classLoader = this.getShellService().getServiceClassLoader()) instanceof SiblingClassLoader) {
            SiblingClassLoader scl = (SiblingClassLoader)classLoader;
            Enumeration<URL> urls = scl.getAllResources();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                console.writeLine(url.toString());
            }
        }
    }

    private void mem(boolean gc, @NonNull ShellConsole console) {
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        console.writeLine("------------------------------------");
        console.writeLine("Memory information about current JVM");
        console.writeLine("------------------------------------");
        console.writeLine("%-23s %12s", "Available memory", StringUtils.toHumanFriendlyByteSize(max));
        console.writeLine("%-23s %12s", "Total memory", StringUtils.toHumanFriendlyByteSize(total));
        console.writeLine("%-23s %12s", "Used memory", StringUtils.toHumanFriendlyByteSize(total - free));
        console.writeLine("%-23s %12s", "Free memory before GC", StringUtils.toHumanFriendlyByteSize(free));
        if (gc) {
            System.gc();
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long after = Runtime.getRuntime().freeMemory();
            console.writeLine("%-23s %12s", "Free memory after GC", StringUtils.toHumanFriendlyByteSize(after));
            console.writeLine("%-23s %12s", "Memory gained with GC", StringUtils.toHumanFriendlyByteSize(after - free));
        } else {
            console.writeLine("%-23s %12s", "Free memory", StringUtils.toHumanFriendlyByteSize(free));
        }
        console.writeLine("------------------------------------");
    }

    @NonNull
    private String escape(@NonNull String s) {
        return s.replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f");
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return SysInfoCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return SysInfoCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Displays current JVM runtime information";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

