/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.converter.RulesToParameters;
import com.aspectran.core.context.rule.params.TransletParameters;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.TransletCommandLine;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.ShellService;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class TransletCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "translet";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public TransletCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("l").longName("list").hasValues().optionalValue().valueName("keywords").desc("Print list of all translets or those filtered by given keywords").build());
        this.addOption(Option.builder("la").longName("list-all").hasValues().optionalValue().valueName("keywords").desc("Print list of all translets or those filtered by given keywords (Include all translets that are not exposed)").build());
        this.addOption(Option.builder("d").longName("detail").hasValues().optionalValue().valueName("translet_name").desc("Print detailed information for the translet").build());
        this.addOption(Option.builder("da").longName("detail-all").hasValues().optionalValue().valueName("translet_name").desc("Print detailed information for the translet (Include all translets that are not exposed)").build());
        this.addOption(Option.builder("m").longName("method").hasValue().optionalValue().valueName("request_method").desc("Specifies the request method for the translet\n(GET, PUT, POST, DELETE)").build());
        this.addOption(Option.builder("v").longName("verbose").desc("Display description about the translet").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.put("<translet_name>", "Name of the translet to execute");
        arguments.setRequired(false);
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        ShellService shellService = this.getActiveShellService();
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasOption("list")) {
            String[] keywords = options.getValues("list");
            this.listTranslets(shellService, console, keywords, false);
        } else if (options.hasOption("list-all")) {
            String[] keywords = options.getValues("list-all");
            this.listTranslets(shellService, console, keywords, true);
        } else if (options.hasOption("detail")) {
            String[] transletNames = options.getValues("detail");
            String method = options.getValue("method");
            MethodType requestMethod = MethodType.resolve(method);
            if (method != null && requestMethod == null) {
                console.writeError("No request method type for '" + method + "'");
                return;
            }
            this.describeTransletRule(shellService, console, transletNames, requestMethod, false);
        } else if (options.hasOption("detail-all")) {
            String[] transletNames = options.getValues("detail-all");
            String method = options.getValue("method");
            MethodType requestMethod = MethodType.resolve(method);
            if (method != null && requestMethod == null) {
                console.writeError("No request method type for '" + method + "'");
                return;
            }
            this.describeTransletRule(shellService, console, transletNames, requestMethod, true);
        } else if (options.hasArgs()) {
            CommandLineParser lineParser = new CommandLineParser(options.getFirstArg());
            TransletCommandLine transletCommandLine = new TransletCommandLine(lineParser);
            if (options.hasOption("verbose")) {
                transletCommandLine.setVerbose(true);
            }
            try {
                shellService.translate(transletCommandLine);
            }
            catch (TransletNotFoundException e) {
                console.writeError("No translet mapped to '" + e.getTransletName() + "'");
            }
        } else {
            this.printQuickHelp(console);
        }
    }

    private void listTranslets(@NonNull ShellService shellService, @NonNull ShellConsole console, @Nullable String[] keywords, boolean all) {
        TransletRuleRegistry transletRuleRegistry = shellService.getActivityContext().getTransletRuleRegistry();
        Collection<TransletRule> transletRules = transletRuleRegistry.getTransletRules();
        console.writeLine("-%4s-+-%-59s-+-%-5s-", "----", "-----------------------------------------------------------", "-----");
        console.writeLine(" %4s | %-59s | %-5s ", "No.", "Translet Name", "Async");
        console.writeLine("-%4s-+-%-59s-+-%-5s-", "----", "-----------------------------------------------------------", "-----");
        int num = 0;
        for (TransletRule transletRule : transletRules) {
            MethodType[] requestMethods;
            Object transletName = transletRule.getName();
            if (!all && !shellService.isAcceptable((String)transletName)) continue;
            if (keywords != null) {
                boolean exists = false;
                for (String kw : keywords) {
                    if (!((String)transletName).toLowerCase().contains(kw.toLowerCase())) continue;
                    exists = true;
                    break;
                }
                if (!exists) continue;
            }
            if ((requestMethods = transletRule.getAllowedMethods()) != null) {
                transletName = StringUtils.toDelimitedString((Object[])requestMethods, ",") + " " + (String)transletName;
            }
            console.write("%5d | %-59s |", ++num, transletName);
            if (transletRule.isAsync()) {
                console.successStyle();
            }
            console.writeLine(" %-5s ", transletRule.isAsync());
            if (!transletRule.isAsync()) continue;
            console.resetStyle();
        }
        if (num == 0) {
            console.writeLine("%31s %s", " ", "- No Data -");
        }
        console.writeLine("-%4s-+-%-59s-+-%-5s-", "----", "-----------------------------------------------------------", "-----");
    }

    private void describeTransletRule(@NonNull ShellService shellService, @NonNull ShellConsole console, @Nullable String[] transletNames, @Nullable MethodType requestMethod, boolean all) throws IOException {
        Collection<TransletRule> transletRules;
        TransletRuleRegistry transletRuleRegistry = shellService.getActivityContext().getTransletRuleRegistry();
        if (transletNames == null || transletNames.length == 0) {
            transletRules = transletRuleRegistry.getTransletRules();
        } else {
            transletRules = new ArrayList<TransletRule>();
            for (String transletName : transletNames) {
                TransletRule transletRule;
                if (requestMethod != null) {
                    transletRule = transletRuleRegistry.getTransletRule(transletName, requestMethod);
                } else {
                    MethodType requestMethod2 = null;
                    for (MethodType methodType : MethodType.values()) {
                        if (!transletName.startsWith(methodType.name() + " ")) continue;
                        requestMethod2 = methodType;
                        transletName = transletName.substring(methodType.name().length()).trim();
                    }
                    transletRule = requestMethod2 != null ? transletRuleRegistry.getTransletRule(transletName, requestMethod2) : transletRuleRegistry.getTransletRule(transletName);
                }
                if (transletRule == null) {
                    if (requestMethod != null) {
                        console.writeError("Unknown translet: " + String.valueOf((Object)requestMethod) + " " + transletName);
                    } else {
                        console.writeError("Unknown translet: " + transletName);
                    }
                    return;
                }
                transletRules.add(transletRule);
            }
        }
        int count = 0;
        for (TransletRule transletRule : transletRules) {
            if (!all && !shellService.isAcceptable(transletRule.getName())) continue;
            TransletParameters transletParameters = RulesToParameters.toTransletParameters(transletRule);
            if (count == 0) {
                console.writeLine("----------------------------------------------------------------------------");
            }
            Object aponWriter = ((AponWriter)new AponWriter(console.getWriter()).nullWritable(false)).autoFlush(true);
            ((AponWriter)aponWriter).write(transletParameters);
            ((AponWriter)aponWriter).flush();
            console.writeLine("----------------------------------------------------------------------------");
            ++count;
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return TransletCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return TransletCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Translet run, or you can find them";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

