/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.shell.command.option.UnrecognizedOptionException;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.Collection;
import java.util.Iterator;

public class AmbiguousOptionException
extends UnrecognizedOptionException {
    private static final long serialVersionUID = 7582734904376616120L;
    private final Collection<String> matchingOptions;

    public AmbiguousOptionException(String option, Collection<String> matchingOptions) {
        super(AmbiguousOptionException.createMessage(option, matchingOptions), option);
        this.matchingOptions = matchingOptions;
    }

    public Collection<String> getMatchingOptions() {
        return this.matchingOptions;
    }

    @NonNull
    private static String createMessage(String option, @NonNull Collection<String> matchingOptions) {
        StringBuilder buf = new StringBuilder("Ambiguous option: '");
        buf.append(option);
        buf.append("'  (could be: ");
        Iterator<String> it = matchingOptions.iterator();
        while (it.hasNext()) {
            buf.append("'");
            buf.append(it.next());
            buf.append("'");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }
}

