/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.shell.command.option.AlreadySelectedException;
import com.aspectran.shell.command.option.AmbiguousOptionException;
import com.aspectran.shell.command.option.MissingOptionException;
import com.aspectran.shell.command.option.MissingOptionValueException;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionGroup;
import com.aspectran.shell.command.option.OptionParser;
import com.aspectran.shell.command.option.OptionParserException;
import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.Options;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.command.option.UnrecognizedOptionException;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class DefaultOptionParser
implements OptionParser {
    private ParsedOptions parsedOptions;
    private Options options;
    private boolean skipParsingAtNonOption;
    private String currentToken;
    private Option currentOption;
    private List<Object> expectedOpts;
    private final boolean allowPartialMatching;

    public DefaultOptionParser() {
        this(false);
    }

    public DefaultOptionParser(boolean allowPartialMatching) {
        this.allowPartialMatching = allowPartialMatching;
    }

    @Override
    public ParsedOptions parse(Options options, String[] args) throws OptionParserException {
        return this.parse(options, args, null);
    }

    @Override
    public ParsedOptions parse(Options options, String[] args, Properties properties) throws OptionParserException {
        return this.parse(options, args, properties, false);
    }

    @Override
    public ParsedOptions parse(Options options, String[] args, boolean skipParsingAtNonOption) throws OptionParserException {
        return this.parse(options, args, null, skipParsingAtNonOption);
    }

    @Override
    public ParsedOptions parse(@NonNull Options options, String[] args, Properties properties, boolean skipParsingAtNonOption) throws OptionParserException {
        this.options = options;
        this.skipParsingAtNonOption = skipParsingAtNonOption;
        this.currentOption = null;
        this.expectedOpts = new ArrayList<Object>(options.getRequiredOptions());
        for (OptionGroup group : options.getOptionGroups()) {
            group.setSelected(null);
        }
        this.parsedOptions = new ParsedOptions();
        if (args != null) {
            for (String argument : args) {
                this.handleToken(argument);
            }
        }
        this.checkRequiredOptionValues();
        this.handleProperties(properties);
        this.checkRequiredOptions();
        return this.parsedOptions;
    }

    private void handleProperties(Properties properties) throws OptionParserException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            boolean selected;
            String name = e.nextElement().toString();
            Option opt = this.options.getOption(name);
            if (opt == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", name);
            }
            OptionGroup group = this.options.getOptionGroup(opt);
            boolean bl = selected = group != null && group.getSelected() != null;
            if (this.parsedOptions.hasOption(name) || selected) continue;
            String value = properties.getProperty(name);
            if (opt.hasValue()) {
                if (opt.getValues() == null || opt.getValues().length == 0) {
                    opt.addValue(value);
                }
            } else if (!"yes".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value)) continue;
            this.handleOption(opt);
            this.currentOption = null;
        }
    }

    private void handleToken(String token) throws OptionParserException {
        this.currentToken = token;
        if (!"--".equals(token)) {
            if (this.currentOption != null && this.currentOption.acceptsValue() && !this.currentOption.isWithEqualSign() && this.isArgument(token)) {
                String t = OptionUtils.stripLeadingAndTrailingQuotes(token);
                this.currentOption.addValue(t);
            } else if (token.startsWith("--")) {
                String t = OptionUtils.stripLeadingHyphens(token);
                this.handleLongOption(t);
            } else if (token.startsWith("-") && token.length() > 1) {
                String t = OptionUtils.stripLeadingHyphens(token);
                this.handleShortAndLongOption(t);
            } else {
                this.handleUnknownToken(token);
            }
        }
        if (this.currentOption != null && !this.currentOption.acceptsValue()) {
            this.currentOption = null;
        }
    }

    private void handleLongOption(@NonNull String token) throws OptionParserException {
        if (token.indexOf(61) == -1) {
            this.handleLongOptionWithoutEqual(token);
        } else {
            this.handleLongOptionWithEqual(token);
        }
    }

    private void handleLongOptionWithoutEqual(String token) throws OptionParserException {
        List<String> matchingOpts = this.getMatchingLongOptions(token);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(token)) {
                throw new AmbiguousOptionException(token, matchingOpts);
            }
            String key = this.options.hasLongOption(token) ? token : matchingOpts.get(0);
            this.handleOption(this.options.getOption(key));
        }
    }

    private void handleLongOptionWithEqual(@NonNull String token) throws OptionParserException {
        int pos = token.indexOf(61);
        String name = token.substring(0, pos);
        String value = token.substring(pos + 1);
        List<String> matchingOpts = this.getMatchingLongOptions(name);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(name)) {
                throw new AmbiguousOptionException(name, matchingOpts);
            }
            String key = this.options.hasLongOption(name) ? name : matchingOpts.get(0);
            Option option = this.options.getOption(key);
            if (option.acceptsValue()) {
                this.handleOption(option);
                this.currentOption.addValue(value);
                this.currentOption = null;
            } else {
                this.handleUnknownToken(this.currentToken);
            }
        }
    }

    private void handleShortAndLongOption(@NonNull String token) throws OptionParserException {
        if (token.length() == 1) {
            if (this.options.hasShortOption(token)) {
                this.handleOption(this.options.getOption(token));
            } else {
                this.handleUnknownToken(this.currentToken);
            }
            return;
        }
        int pos = token.indexOf(61);
        if (pos == -1) {
            if (this.options.hasShortOption(token)) {
                this.handleOption(this.options.getOption(token));
            } else if (!this.getMatchingLongOptions(token).isEmpty()) {
                this.handleLongOptionWithoutEqual(token);
            } else {
                Option option;
                String name = this.getLongPrefix(token);
                if (name != null && !(option = this.options.getOption(name)).isWithEqualSign() && option.acceptsValue()) {
                    this.handleOption(this.options.getOption(name));
                    this.currentOption.addValue(token.substring(name.length()));
                    this.currentOption = null;
                    return;
                }
                this.handleUnknownToken(this.currentToken);
            }
        } else {
            String name = token.substring(0, pos);
            String value = token.substring(pos + 1);
            Option option = this.options.getOption(name);
            if (option != null && option.acceptsValue()) {
                this.handleOption(option);
                this.currentOption.addValue(value);
                this.currentOption = null;
            } else {
                this.handleLongOptionWithEqual(token);
            }
        }
    }

    private void handleUnknownToken(@NonNull String token) throws OptionParserException {
        if (token.startsWith("-") && token.length() > 1 && !this.skipParsingAtNonOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + token, token);
        }
        this.parsedOptions.addArg(token);
    }

    private void handleOption(Option option) throws OptionParserException {
        this.checkRequiredOptionValues();
        try {
            option = option.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new OptionParserException("A CloneNotSupportedException was thrown: " + e.getMessage() + "; Class " + String.valueOf(option.getClass()) + " must implement the Cloneable interface");
        }
        this.updateRequiredOptions(option);
        this.parsedOptions.addOption(option);
        this.currentOption = option.hasValue() ? option : null;
    }

    private void updateRequiredOptions(@NonNull Option option) throws AlreadySelectedException {
        if (option.isRequired()) {
            this.expectedOpts.remove(option.getKey());
        }
        if (this.options.getOptionGroup(option) != null) {
            OptionGroup group = this.options.getOptionGroup(option);
            if (group.isRequired()) {
                this.expectedOpts.remove(group);
            }
            group.setSelected(option);
        }
    }

    private void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private void checkRequiredOptionValues() throws OptionParserException {
        if (this.currentOption != null && this.currentOption.requiresValue()) {
            throw new MissingOptionValueException(this.currentOption);
        }
    }

    private boolean isArgument(String token) {
        return !this.isOption(token) || this.isNegativeNumber(token);
    }

    private boolean isNegativeNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isOption(String token) {
        return this.isLongOption(token) || this.isShortOption(token);
    }

    private boolean isShortOption(@NonNull String token) {
        String name;
        if (!token.startsWith("-") || token.length() == 1) {
            return false;
        }
        int pos = token.indexOf("=");
        String string = name = pos == -1 ? token.substring(1) : token.substring(1, pos);
        if (this.options.hasShortOption(name)) {
            return true;
        }
        return !name.isEmpty() && this.options.hasShortOption(String.valueOf(name.charAt(0)));
    }

    private boolean isLongOption(@NonNull String token) {
        String t;
        if (!token.startsWith("-") || token.length() == 1) {
            return false;
        }
        int pos = token.indexOf("=");
        String string = t = pos == -1 ? token : token.substring(0, pos);
        if (!this.getMatchingLongOptions(t).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(token) != null && !token.startsWith("--");
    }

    private List<String> getMatchingLongOptions(String token) {
        if (this.allowPartialMatching) {
            return this.options.getMatchingOptions(token);
        }
        ArrayList<String> matches = new ArrayList<String>(1);
        if (this.options.hasLongOption(token)) {
            Option option = this.options.getOption(token);
            matches.add(option.getLongName());
        }
        return matches;
    }

    private String getLongPrefix(@NonNull String token) {
        String name = null;
        for (int i = token.length() - 2; i > 1; --i) {
            String prefix = token.substring(0, i);
            if (!this.options.hasLongOption(prefix)) continue;
            name = prefix;
            break;
        }
        return name;
    }
}

