/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionGroup;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Options
implements Serializable {
    private static final long serialVersionUID = -6416293453155205092L;
    private final Map<String, Option> shortOpts = new LinkedHashMap<String, Option>();
    private final Map<String, Option> longOpts = new LinkedHashMap<String, Option>();
    private final List<Object> requiredOpts = new ArrayList<Object>();
    private final Map<String, OptionGroup> optionGroups = new LinkedHashMap<String, OptionGroup>();
    private String title = "Options:";
    private boolean skipParsingAtNonOption;

    public Options() {
        this(false);
    }

    public Options(boolean skipParsingAtNonOption) {
        this.skipParsingAtNonOption = skipParsingAtNonOption;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isSkipParsingAtNonOption() {
        return this.skipParsingAtNonOption;
    }

    public void setSkipParsingAtNonOption(boolean skipParsingAtNonOption) {
        this.skipParsingAtNonOption = skipParsingAtNonOption;
    }

    public Options addOptionGroup(@NonNull OptionGroup group) {
        if (group.isRequired()) {
            this.requiredOpts.add(group);
        }
        for (Option option : group.getOptions()) {
            option.setRequired(false);
            this.addOption(option);
            this.optionGroups.put(option.getKey(), group);
        }
        return this;
    }

    Collection<OptionGroup> getOptionGroups() {
        return new HashSet<OptionGroup>(this.optionGroups.values());
    }

    public Options addOption(@NonNull Option opt) {
        String key = opt.getKey();
        if (opt.hasLongName()) {
            this.longOpts.put(opt.getLongName(), opt);
        }
        if (opt.isRequired()) {
            if (this.requiredOpts.contains(key)) {
                this.requiredOpts.remove(this.requiredOpts.indexOf(key));
            }
            this.requiredOpts.add(key);
        }
        this.shortOpts.put(key, opt);
        return this;
    }

    public boolean isEmpty() {
        return this.shortOpts.isEmpty();
    }

    public Collection<Option> getAllOptions() {
        return Collections.unmodifiableCollection(this.shortOpts.values());
    }

    public List<Option> getHelpOptions() {
        return new ArrayList<Option>(this.shortOpts.values());
    }

    public List<Object> getRequiredOptions() {
        return Collections.unmodifiableList(this.requiredOpts);
    }

    public Option getOption(String name) {
        if (this.shortOpts.containsKey(name)) {
            return this.shortOpts.get(name);
        }
        return this.longOpts.get(name);
    }

    public List<String> getMatchingOptions(String name) {
        ArrayList<String> matchingOpts = new ArrayList<String>();
        if (this.longOpts.containsKey(name)) {
            return Collections.singletonList(name);
        }
        for (String longOpt : this.longOpts.keySet()) {
            if (!longOpt.startsWith(name)) continue;
            matchingOpts.add(longOpt);
        }
        return matchingOpts;
    }

    public boolean hasOption(String name) {
        return this.shortOpts.containsKey(name) || this.longOpts.containsKey(name);
    }

    public boolean hasLongOption(String name) {
        return this.longOpts.containsKey(name);
    }

    public boolean hasShortOption(String name) {
        return this.shortOpts.containsKey(name);
    }

    public OptionGroup getOptionGroup(@NonNull Option opt) {
        return this.optionGroups.get(opt.getKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ Options: [ short ");
        sb.append(this.shortOpts);
        sb.append(" ] [ long ");
        sb.append(this.longOpts);
        sb.append(" ]");
        return sb.toString();
    }
}

