/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.console;

import com.aspectran.core.context.config.ShellStyleConfig;
import com.aspectran.shell.command.ConsoleCommander;
import com.aspectran.shell.console.PromptStringBuilder;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.File;
import java.nio.charset.Charset;

public abstract class AbstractShellConsole
implements ShellConsole {
    private final String encoding;
    private String commandPrompt = "Aspectran> ";
    private File workingDir;
    private ConsoleCommander consoleCommander;
    private String[] primaryStyle;
    private String[] secondaryStyle;
    private String[] successStyle;
    private String[] dangerStyle;
    private String[] warningStyle;
    private String[] infoStyle;

    public AbstractShellConsole(String encoding) {
        this.encoding = encoding != null ? encoding : Charset.defaultCharset().name();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public ConsoleCommander getConsoleCommander() {
        return this.consoleCommander;
    }

    @Override
    public void setConsoleCommander(ConsoleCommander consoleCommander) {
        this.consoleCommander = consoleCommander;
    }

    @Override
    public String getCommandPrompt() {
        return this.commandPrompt;
    }

    @Override
    public void setCommandPrompt(String commandPrompt) {
        this.commandPrompt = commandPrompt;
    }

    @Override
    public String readLine() {
        return this.readLine(null);
    }

    @Override
    public String readPassword() {
        return this.readPassword(null);
    }

    protected String readMultiCommandLine(String line) {
        String quote;
        if (line == null) {
            return null;
        }
        if ("//".equals(line)) {
            String next = this.readRawCommandLine("// ");
            if (next.isEmpty()) {
                return next;
            }
            this.readMultiCommandLine("//");
        }
        if ((quote = this.searchQuote((String)line)) != null || ((String)line).endsWith("\\")) {
            String next = this.readRawCommandLine("> ").trim();
            line = next.startsWith("//") ? this.readMultiCommandLine((String)line) : (quote != null ? (String)line + System.lineSeparator() + next : ((String)line).substring(0, ((String)line).length() - "\\".length()).trim() + " " + next);
        }
        if ((quote = this.searchQuote((String)line)) != null) {
            return this.readMultiCommandLine((String)line);
        }
        if (((String)line).endsWith("\\")) {
            line = this.readMultiCommandLine((String)line);
        }
        return line;
    }

    protected String readMultiLine(String line) {
        if (line == null) {
            line = this.readRawLine("> ");
        }
        if (((String)line).endsWith("\\")) {
            line = ((String)line).substring(0, ((String)line).length() - "\\".length()) + System.lineSeparator() + this.readMultiLine(null);
        }
        return line;
    }

    protected abstract String readRawCommandLine(String var1);

    protected abstract String readRawLine(String var1);

    @Nullable
    private String searchQuote(@NonNull String line) {
        boolean doubleQuote = false;
        boolean singleQuote = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"' && !singleQuote) {
                doubleQuote = !doubleQuote;
                continue;
            }
            if (c != '\'' || doubleQuote) continue;
            singleQuote = !singleQuote;
        }
        if (doubleQuote) {
            return "\"";
        }
        if (singleQuote) {
            return "'";
        }
        return null;
    }

    @Override
    public void setShellStyleConfig(ShellStyleConfig shellStyleConfig) {
        if (shellStyleConfig == null) {
            throw new IllegalArgumentException("shellStyleConfig must not be null");
        }
        this.primaryStyle = shellStyleConfig.getPrimaryStyle();
        this.secondaryStyle = shellStyleConfig.getSecondaryStyle();
        this.successStyle = shellStyleConfig.getSuccessStyle();
        this.dangerStyle = shellStyleConfig.getDangerStyle();
        this.warningStyle = shellStyleConfig.getWarningStyle();
        this.infoStyle = shellStyleConfig.getInfoStyle();
        this.resetStyle();
    }

    @Override
    public String[] getPrimaryStyle() {
        return this.primaryStyle;
    }

    @Override
    public String[] getSecondaryStyle() {
        return this.secondaryStyle;
    }

    @Override
    public String[] getSuccessStyle() {
        return this.successStyle;
    }

    @Override
    public String[] getDangerStyle() {
        return this.dangerStyle;
    }

    @Override
    public String[] getWarningStyle() {
        return this.warningStyle;
    }

    @Override
    public String[] getInfoStyle() {
        return this.infoStyle;
    }

    @Override
    public boolean confirmRestart() {
        if (this.checkReadingState()) {
            return false;
        }
        PromptStringBuilder psb = this.newPromptStringBuilder().warningStyle().append("Would you like to restart this shell [Y/n]? ");
        String yn = this.readLine(psb);
        return yn == null || yn.isEmpty() || yn.equalsIgnoreCase("Y");
    }

    @Override
    public boolean confirmQuit() {
        if (this.checkReadingState()) {
            return false;
        }
        PromptStringBuilder psb = this.newPromptStringBuilder().warningStyle().append("Are you sure you want to quit [Y/n]? ");
        String yn = this.readLine(psb);
        return yn == null || yn.isEmpty() || yn.equalsIgnoreCase("Y");
    }

    private boolean checkReadingState() {
        if (this.isReading()) {
            this.setStyle(this.getDangerStyle());
            this.writeAbove("Illegal State");
            this.resetStyle();
            return true;
        }
        return false;
    }
}

