/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.console;

import com.aspectran.shell.console.AbstractShellConsole;
import com.aspectran.shell.console.DefaultPromptStringBuilder;
import com.aspectran.shell.console.PromptStringBuilder;
import com.aspectran.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

public class DefaultShellConsole
extends AbstractShellConsole {
    private volatile boolean reading;

    public DefaultShellConsole() {
        this(null);
    }

    public DefaultShellConsole(String encoding) {
        super(encoding);
    }

    @Override
    public String getEncoding() {
        return Charset.defaultCharset().name();
    }

    @Override
    public PrintStream getOutput() {
        return System.out;
    }

    @Override
    public PrintWriter getWriter() {
        if (System.console() != null) {
            return System.console().writer();
        }
        return new PrintWriter(System.out, true);
    }

    @Override
    public void setCommandHistoryFile(String historyFile) {
    }

    @Override
    public List<String> getCommandHistory() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void clearCommandHistory() {
    }

    @Override
    public String readCommandLine() {
        String prompt = this.getCommandPrompt();
        String line = this.readMultiCommandLine(this.readRawLine(prompt));
        return line != null ? line.trim() : null;
    }

    @Override
    public PromptStringBuilder newPromptStringBuilder() {
        return new DefaultPromptStringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine(PromptStringBuilder promptStringBuilder) {
        String line;
        Object prompt = null;
        String defaultValue = null;
        if (promptStringBuilder != null) {
            prompt = promptStringBuilder.toString();
            defaultValue = promptStringBuilder.getDefaultValue();
        }
        if (defaultValue != null) {
            String prompt2 = "[" + defaultValue + "] ";
            prompt = prompt != null ? (String)prompt + prompt2 : prompt2;
        }
        try {
            this.reading = true;
            line = this.readMultiLine(this.readRawLine((String)prompt));
        }
        finally {
            this.reading = false;
        }
        if (defaultValue != null && StringUtils.isEmpty(line)) {
            return defaultValue;
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readPassword(PromptStringBuilder promptStringBuilder) {
        String line;
        Object prompt = null;
        String defaultValue = null;
        if (promptStringBuilder != null) {
            prompt = promptStringBuilder.toString();
            defaultValue = promptStringBuilder.getDefaultValue();
        }
        if (defaultValue != null) {
            String prompt2 = "[" + StringUtils.repeat('*', 8) + "] ";
            prompt = prompt != null ? (String)prompt + prompt2 : prompt2;
        }
        try {
            this.reading = true;
            line = this.readRawPassword((String)prompt);
        }
        finally {
            this.reading = false;
        }
        if (defaultValue != null && StringUtils.isEmpty(line)) {
            return defaultValue;
        }
        return line;
    }

    @Override
    protected String readRawCommandLine(String prompt) {
        return this.readRawLine(prompt);
    }

    @Override
    protected String readRawLine(String prompt) {
        try {
            String line;
            if (System.console() != null) {
                line = System.console().readLine(prompt, new Object[0]);
            } else {
                if (prompt != null) {
                    this.write(prompt);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                line = reader.readLine();
            }
            return line;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String readRawPassword(String prompt) {
        if (System.console() != null) {
            return new String(System.console().readPassword(prompt, new Object[0]));
        }
        return this.readRawLine(prompt);
    }

    @Override
    public void write(String str) {
        System.out.print(str);
    }

    @Override
    public void write(String format, Object ... args) {
        System.out.printf(format, args);
    }

    @Override
    public void writeLine(String str) {
        System.out.println(str);
    }

    @Override
    public void writeLine(String format, Object ... args) {
        System.out.printf(format + "%n", args);
    }

    @Override
    public void writeLine() {
        System.out.println();
    }

    @Override
    public void writeError(String str) {
        System.err.println(str);
    }

    @Override
    public void writeError(String format, Object ... args) {
        System.err.printf(format + "%n", args);
    }

    @Override
    public void writeAbove(String str) {
        this.writeLine(str);
    }

    @Override
    public void clearScreen() {
        System.out.print("\u001b[H\u001b[2J");
        System.out.flush();
    }

    @Override
    public void clearLine() {
    }

    @Override
    public void redrawLine() {
    }

    @Override
    public boolean isReading() {
        return this.reading;
    }

    @Override
    public boolean hasStyle() {
        return false;
    }

    @Override
    public void setStyle(String ... styles) {
    }

    @Override
    public void resetStyle() {
    }

    @Override
    public void resetStyle(String ... styles) {
    }

    @Override
    public void secondaryStyle() {
    }

    @Override
    public void successStyle() {
    }

    @Override
    public void dangerStyle() {
    }

    @Override
    public void warningStyle() {
    }

    @Override
    public void infoStyle() {
    }
}

