/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.shell.command.DefaultConsoleCommander;
import com.aspectran.shell.jline.command.JLineConsoleCommander;
import com.aspectran.shell.jline.console.JLineShellConsole;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.InsufficientEnvironmentException;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.File;

public class JLineAspectranShell {
    public static void main(String[] args) {
        String basePath = AspectranConfig.determineBasePath(args);
        File aspectranConfigFile = AspectranConfig.determineAspectranConfigFile(args);
        try {
            JLineAspectranShell.bootstrap(basePath, aspectranConfigFile);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void bootstrap(File aspectranConfigFile) {
        JLineAspectranShell.bootstrap(null, aspectranConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bootstrap(@Nullable String basePath, File aspectranConfigFile) {
        if (aspectranConfigFile == null) {
            throw new IllegalArgumentException("aspectranConfigFile must not be null");
        }
        DefaultConsoleCommander commander = null;
        int exitStatus = 0;
        try {
            JLineShellConsole console = new JLineShellConsole();
            commander = new JLineConsoleCommander(console);
            commander.configure(basePath, aspectranConfigFile);
            commander.run();
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause(e);
            if (cause instanceof InsufficientEnvironmentException) {
                InsufficientEnvironmentException that = (InsufficientEnvironmentException)cause;
                System.err.println(that.getPrettyMessage());
            } else {
                System.err.println(cause.getMessage());
                e.printStackTrace(System.err);
            }
            exitStatus = 1;
        }
        finally {
            if (commander != null) {
                commander.release();
            }
        }
        System.exit(exitStatus);
    }
}

