/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.ShellService;
import java.util.List;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class CommandCompleter
implements Completer {
    private final ShellConsole console;
    private boolean limited;

    public CommandCompleter(ShellConsole console) {
        if (console == null) {
            throw new IllegalArgumentException("console must not be null");
        }
        this.console = console;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        if (!this.isLimited() && this.console.getConsoleCommander() != null) {
            if (line.wordIndex() == 0) {
                this.makeCommandCandidates(line.word(), candidates);
                this.makeTransletCandidates(line.word(), candidates);
            } else if (line.wordIndex() > 0) {
                String word = (String)line.words().get(0);
                this.makeArgumentsCandidates(word, line.word(), candidates);
            }
        }
    }

    private void makeCommandCandidates(String word, List<Candidate> candidates) {
        CommandRegistry commandRegistry = this.console.getConsoleCommander().getCommandRegistry();
        if (commandRegistry != null) {
            for (Command command : commandRegistry.getAllCommands()) {
                String name = command.getDescriptor().getName();
                if (word != null && !name.startsWith(word) && !(name + "\\").startsWith(word)) continue;
                candidates.add(new Candidate(name, name, command.getDescriptor().getNamespace(), null, null, null, true));
            }
        }
    }

    private void makeArgumentsCandidates(String word, String opt, List<Candidate> candidates) {
        Command command;
        CommandRegistry commandRegistry = this.console.getConsoleCommander().getCommandRegistry();
        if (commandRegistry != null && (command = commandRegistry.getCommand(word)) != null) {
            for (Option option : command.getOptions().getAllOptions()) {
                String shortName = null;
                if (option.getName() != null) {
                    shortName = "-" + option.getName();
                }
                String longName = null;
                if (option.getLongName() != null) {
                    longName = "--" + option.getLongName();
                }
                String dispName = shortName != null && longName != null ? shortName + "," + longName : (shortName != null ? shortName : longName);
                if (shortName != null && (opt == null || shortName.indexOf(opt) == 0)) {
                    candidates.add(new Candidate(shortName, dispName, command.getOptions().getTitle(), null, null, longName, false));
                    continue;
                }
                if (longName == null || opt != null && longName.indexOf(opt) != 0) continue;
                candidates.add(new Candidate(longName, dispName, command.getOptions().getTitle(), null, null, null, false));
            }
            for (Arguments arguments : command.getArgumentsList()) {
                if (arguments.getTitle() == null) continue;
                for (String name : arguments.keySet()) {
                    if (name.startsWith("<") && name.endsWith(">")) continue;
                    candidates.add(new Candidate(name, name, arguments.getTitle(), null, null, null, false));
                }
            }
        }
    }

    private void makeTransletCandidates(String word, List<Candidate> candidates) {
        TransletRuleRegistry transletRuleRegistry;
        ShellService shellService = this.console.getConsoleCommander().getShellService();
        if (shellService != null && shellService.getActivityContext() != null && (transletRuleRegistry = shellService.getActivityContext().getTransletRuleRegistry()) != null) {
            for (TransletRule transletRule : transletRuleRegistry.getTransletRules()) {
                String name;
                String dispName = name = transletRule.getName();
                if (!shellService.isAcceptable(name) || word != null && !name.startsWith(word)) continue;
                if (transletRule.hasPathVariables()) {
                    name = transletRule.getNamePattern().toString();
                    name = name.replaceAll(" [*+?] | [*+?]$|[*+?]", " ").trim();
                }
                if (name.isEmpty()) continue;
                candidates.add(new Candidate(name, dispName, "translets", null, null, null, true));
            }
        }
    }
}

