/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.jline.console.JLineShellConsole;
import com.aspectran.shell.service.ShellService;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.regex.Pattern;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class CommandHighlighter
implements Highlighter {
    private final ShellConsole console;
    private boolean limited;

    public CommandHighlighter(ShellConsole console) {
        if (console == null) {
            throw new IllegalArgumentException("console must not be null");
        }
        this.console = console;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public AttributedString highlight(LineReader reader, String buffer) {
        AttributedStringBuilder asb;
        if (!this.isLimited() && this.console.getConsoleCommander() != null) {
            String str = StringUtils.trimLeadingWhitespace(buffer);
            String best = this.getMatchedCommandName(str);
            if (best == null) {
                best = this.getMatchedTransletName(str);
            }
            if (best != null) {
                String prefix = str.length() < buffer.length() ? buffer.substring(0, buffer.length() - str.length()) : "";
                if (buffer.endsWith("\\")) {
                    AttributedStringBuilder asb2 = this.newAttributedStringBuilder(buffer);
                    asb2.append((CharSequence)(prefix + best), AttributedStyle.BOLD);
                    asb2.append((CharSequence)buffer.substring(prefix.length() + best.length(), buffer.length() - "\\".length()));
                    asb2.append(new AttributedString((CharSequence)buffer.substring(buffer.length() - "\\".length()), AttributedStyle.DEFAULT.foreground(10)));
                    return asb2.toAttributedString();
                }
                AttributedStringBuilder asb3 = this.newAttributedStringBuilder(buffer);
                asb3.append((CharSequence)(prefix + best), AttributedStyle.BOLD);
                asb3.append((CharSequence)buffer.substring(prefix.length() + best.length()));
                return asb3.toAttributedString();
            }
        }
        if (buffer.startsWith("//") && buffer.endsWith("\\")) {
            asb = this.newAttributedStringBuilder(buffer);
            asb.append(new AttributedString((CharSequence)buffer.substring(0, "//".length()), AttributedStyle.DEFAULT.foreground(12)));
            asb.append(new AttributedString((CharSequence)buffer.substring("//".length(), buffer.length() - "\\".length())));
            asb.append(new AttributedString((CharSequence)buffer.substring(buffer.length() - "\\".length()), AttributedStyle.DEFAULT.foreground(10)));
            return asb.toAttributedString();
        }
        if (buffer.startsWith("//")) {
            asb = this.newAttributedStringBuilder(buffer);
            asb.append(new AttributedString((CharSequence)buffer.substring(0, "//".length()), AttributedStyle.DEFAULT.foreground(12)));
            asb.append(new AttributedString((CharSequence)buffer.substring("//".length())));
            return asb.toAttributedString();
        }
        if (buffer.endsWith("\\")) {
            asb = this.newAttributedStringBuilder(buffer);
            asb.append(new AttributedString((CharSequence)buffer.substring(0, buffer.length() - "\\".length())));
            asb.append(new AttributedString((CharSequence)buffer.substring(buffer.length() - "\\".length()), AttributedStyle.DEFAULT.foreground(10)));
            return asb.toAttributedString();
        }
        AttributedStyle as = null;
        if (this.console.hasStyle()) {
            as = ((JLineShellConsole)this.console).getStyle().getAttributedStyle();
        }
        if (!this.isLimited()) {
            if (as == null) {
                as = AttributedStyle.DEFAULT;
            }
            as = as.foreground(9);
        }
        return new AttributedString((CharSequence)buffer, as);
    }

    @NonNull
    private AttributedStringBuilder newAttributedStringBuilder(@NonNull String buffer) {
        AttributedStringBuilder asb = new AttributedStringBuilder(buffer.length());
        if (this.console.hasStyle()) {
            asb.style(((JLineShellConsole)this.console).getStyle().getAttributedStyle());
        }
        return asb;
    }

    public void setErrorPattern(Pattern pattern) {
    }

    public void setErrorIndex(int i) {
    }

    private String getMatchedCommandName(String buffer) {
        String best = null;
        CommandRegistry commandRegistry = this.console.getConsoleCommander().getCommandRegistry();
        if (commandRegistry != null) {
            int len = 0;
            for (Command command : commandRegistry.getAllCommands()) {
                String name = command.getDescriptor().getName();
                if (name.length() <= len || !buffer.equals(name) && !buffer.startsWith(name + " ") && !buffer.startsWith(name + "\\")) continue;
                best = name;
                len = name.length();
            }
        }
        return best;
    }

    private String getMatchedTransletName(String buffer) {
        TransletRuleRegistry transletRuleRegistry;
        String best = null;
        ShellService shellService = this.console.getConsoleCommander().getShellService();
        if (shellService != null && shellService.getActivityContext() != null && (transletRuleRegistry = shellService.getActivityContext().getTransletRuleRegistry()) != null) {
            int len = 0;
            for (TransletRule transletRule : transletRuleRegistry.getTransletRules()) {
                String name = transletRule.getName();
                if (!shellService.isAcceptable(name)) continue;
                if (transletRule.getNamePattern() != null) {
                    if (!transletRule.getNamePattern().matches(buffer)) continue;
                    return buffer;
                }
                if (name.length() <= len || !buffer.equals(name) && !buffer.startsWith(name + " ") && !buffer.startsWith(name + "\\")) continue;
                best = name;
                len = name.length();
            }
        }
        return best;
    }
}

