/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.shell.console.DefaultPromptStringBuilder;
import com.aspectran.shell.console.PromptStringBuilder;
import com.aspectran.shell.jline.console.JLineShellConsole;
import com.aspectran.shell.jline.console.JLineTerminal;
import com.aspectran.utils.annotation.jsr305.NonNull;

class JLinePromptStringBuilder
extends DefaultPromptStringBuilder {
    private final JLineShellConsole console;
    private final JLineTerminal jlineTerminal;
    private final JLineTerminal.Style baseStyle;
    private JLineTerminal.Style style;

    public JLinePromptStringBuilder(@NonNull JLineShellConsole console) {
        this.console = console;
        this.jlineTerminal = console.getJlineTerminal();
        this.baseStyle = console.getBaseStyle();
        this.style = console.getBaseStyle();
    }

    @Override
    public PromptStringBuilder append(String str) {
        super.append(this.jlineTerminal.toAnsi(str, this.style));
        return this;
    }

    @Override
    public PromptStringBuilder setStyle(String ... styles) {
        return this.setStyle(new JLineTerminal.Style(this.style, styles));
    }

    private PromptStringBuilder setStyle(JLineTerminal.Style style) {
        this.style = style;
        return this;
    }

    @Override
    public PromptStringBuilder resetStyle(String ... styles) {
        this.resetStyle();
        return this.setStyle(styles);
    }

    @Override
    public PromptStringBuilder resetStyle() {
        return this.setStyle(this.baseStyle);
    }

    @Override
    public PromptStringBuilder secondaryStyle() {
        if (this.console.getSecondaryStyle() != null) {
            return this.setStyle(new JLineTerminal.Style(this.console.getSecondaryStyle()));
        }
        return this.resetStyle();
    }

    @Override
    public PromptStringBuilder successStyle() {
        if (this.console.getSecondaryStyle() != null) {
            return this.setStyle(new JLineTerminal.Style(this.console.getSuccessStyle()));
        }
        return this.resetStyle();
    }

    @Override
    public PromptStringBuilder dangerStyle() {
        if (this.console.getSecondaryStyle() != null) {
            return this.setStyle(new JLineTerminal.Style(this.console.getDangerStyle()));
        }
        return this.resetStyle();
    }

    @Override
    public PromptStringBuilder warningStyle() {
        if (this.console.getSecondaryStyle() != null) {
            return this.setStyle(new JLineTerminal.Style(this.console.getWarningStyle()));
        }
        return this.resetStyle();
    }

    @Override
    public PromptStringBuilder infoStyle() {
        if (this.console.getSecondaryStyle() != null) {
            return this.setStyle(new JLineTerminal.Style(this.console.getInfoStyle()));
        }
        return this.resetStyle();
    }
}

