/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.shell.console.AbstractShellConsole;
import com.aspectran.shell.console.CommandReadFailedException;
import com.aspectran.shell.console.PromptStringBuilder;
import com.aspectran.shell.console.ShellConsoleClosedException;
import com.aspectran.shell.jline.console.JLinePromptStringBuilder;
import com.aspectran.shell.jline.console.JLineTerminal;
import com.aspectran.shell.jline.console.TerminalPrintStream;
import com.aspectran.shell.jline.console.TerminalPrintWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;

public class JLineShellConsole
extends AbstractShellConsole {
    private final JLineTerminal jlineTerminal;
    private final PrintStream output;
    private final PrintWriter writer;
    private JLineTerminal.Style baseStyle;

    public JLineShellConsole() throws IOException {
        this(null);
    }

    public JLineShellConsole(String encoding) throws IOException {
        super(encoding);
        this.jlineTerminal = new JLineTerminal(this, encoding);
        this.output = new TerminalPrintStream(this.jlineTerminal);
        this.writer = new TerminalPrintWriter(this.jlineTerminal);
    }

    public JLineTerminal getJlineTerminal() {
        return this.jlineTerminal;
    }

    @Override
    public PrintStream getOutput() {
        return this.output;
    }

    @Override
    public PrintWriter getWriter() {
        return this.writer;
    }

    @Override
    public void setCommandHistoryFile(String historyFile) {
        this.jlineTerminal.setCommandHistoryFile(historyFile);
    }

    @Override
    public List<String> getCommandHistory() {
        return this.jlineTerminal.getCommandHistory();
    }

    @Override
    public void clearCommandHistory() {
        this.jlineTerminal.clearCommandHistory();
    }

    @Override
    public void setCommandPrompt(String commandPrompt) {
        super.setCommandPrompt(this.jlineTerminal.toAnsi(commandPrompt));
    }

    @Override
    public PromptStringBuilder newPromptStringBuilder() {
        return new JLinePromptStringBuilder(this);
    }

    @Override
    public String readCommandLine() {
        try {
            String line = this.readRawCommandLine(this.getCommandPrompt()).trim();
            this.jlineTerminal.getCommandCompleter().setLimited(true);
            this.jlineTerminal.getCommandHighlighter().setLimited(true);
            line = this.readMultiCommandLine(line);
            this.jlineTerminal.getCommandCompleter().setLimited(false);
            this.jlineTerminal.getCommandHighlighter().setLimited(false);
            return line;
        }
        catch (EndOfFileException e) {
            return null;
        }
        catch (IllegalStateException e) {
            if (e.getMessage() == null) {
                return null;
            }
            throw new CommandReadFailedException(e);
        }
        catch (UserInterruptException e) {
            if (this.confirmQuit()) {
                throw new ShellConsoleClosedException();
            }
            return null;
        }
        catch (Exception e) {
            throw new CommandReadFailedException(e);
        }
    }

    @Override
    public String readLine(PromptStringBuilder promptStringBuilder) {
        String prompt = null;
        String defaultValue = null;
        if (promptStringBuilder != null) {
            prompt = promptStringBuilder.toString();
            defaultValue = promptStringBuilder.getDefaultValue();
        }
        try {
            return this.readMultiLine(this.readRawLine(prompt, null, defaultValue));
        }
        catch (EndOfFileException | UserInterruptException e) {
            return defaultValue;
        }
    }

    @Override
    public String readPassword(PromptStringBuilder promptStringBuilder) {
        String prompt = null;
        String defaultValue = null;
        if (promptStringBuilder != null) {
            prompt = promptStringBuilder.toString();
            defaultValue = promptStringBuilder.getDefaultValue();
        }
        try {
            return this.readRawLine(prompt, Character.valueOf('*'), defaultValue);
        }
        catch (EndOfFileException | UserInterruptException e) {
            return defaultValue;
        }
    }

    @Override
    protected String readRawCommandLine(String prompt) {
        return this.jlineTerminal.getCommandReader().readLine(prompt);
    }

    @Override
    protected String readRawLine(String prompt) {
        return this.readRawLine(prompt, null, null);
    }

    private String readRawLine(String prompt, Character mask, String defaultValue) {
        return this.jlineTerminal.getReader().readLine(prompt, mask, defaultValue);
    }

    @Override
    public void write(String str) {
        this.jlineTerminal.write(str);
    }

    @Override
    public void write(String format, Object ... args) {
        this.write(String.format(format, args));
    }

    @Override
    public void writeLine(String str) {
        this.write(str);
        this.writeLine();
    }

    @Override
    public void writeLine(String format, Object ... args) {
        this.writeLine(String.format(format, args));
    }

    @Override
    public void writeLine() {
        this.jlineTerminal.writeLine();
    }

    @Override
    public void writeError(String str) {
        JLineTerminal.Style oldStyle = this.getStyle();
        this.setStyle(this.getDangerStyle());
        this.writeLine(str);
        this.setStyle(oldStyle);
    }

    @Override
    public void writeError(String format, Object ... args) {
        this.writeError(String.format(format, args));
    }

    @Override
    public void writeAbove(String str) {
        this.jlineTerminal.writeAbove(str);
    }

    @Override
    public void clearScreen() {
        this.jlineTerminal.clearScreen();
    }

    @Override
    public void clearLine() {
        this.jlineTerminal.clearLine();
    }

    @Override
    public void redrawLine() {
        this.jlineTerminal.redrawLine();
    }

    @Override
    public boolean isReading() {
        return this.jlineTerminal.isReading();
    }

    protected JLineTerminal.Style getBaseStyle() {
        return this.baseStyle;
    }

    @Override
    public boolean hasStyle() {
        return this.jlineTerminal.hasStyle();
    }

    protected JLineTerminal.Style getStyle() {
        return this.jlineTerminal.getStyle();
    }

    protected void setStyle(JLineTerminal.Style style) {
        this.jlineTerminal.setStyle(style);
    }

    @Override
    public void setStyle(String ... styles) {
        this.jlineTerminal.applyStyle(styles);
    }

    @Override
    public void resetStyle() {
        if (this.baseStyle == null && this.getPrimaryStyle() != null) {
            this.baseStyle = new JLineTerminal.Style(this.getPrimaryStyle());
        }
        this.setStyle(this.baseStyle);
    }

    @Override
    public void resetStyle(String ... styles) {
        this.resetStyle();
        this.setStyle(styles);
    }

    @Override
    public void secondaryStyle() {
        if (this.getSecondaryStyle() != null) {
            this.setStyle(new JLineTerminal.Style(this.getSecondaryStyle()));
        } else {
            this.resetStyle();
        }
    }

    @Override
    public void successStyle() {
        if (this.getSecondaryStyle() != null) {
            this.setStyle(new JLineTerminal.Style(this.getSuccessStyle()));
        } else {
            this.resetStyle();
        }
    }

    @Override
    public void dangerStyle() {
        if (this.getSecondaryStyle() != null) {
            this.setStyle(new JLineTerminal.Style(this.getDangerStyle()));
        } else {
            this.resetStyle();
        }
    }

    @Override
    public void warningStyle() {
        if (this.getSecondaryStyle() != null) {
            this.setStyle(new JLineTerminal.Style(this.getWarningStyle()));
        } else {
            this.resetStyle();
        }
    }

    @Override
    public void infoStyle() {
        if (this.getSecondaryStyle() != null) {
            this.setStyle(new JLineTerminal.Style(this.getInfoStyle()));
        } else {
            this.resetStyle();
        }
    }
}

