/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.jline.console.CommandCompleter;
import com.aspectran.shell.jline.console.CommandHighlighter;
import com.aspectran.shell.jline.console.JLineTextStyler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jline.reader.Completer;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import org.jline.widget.AutosuggestionWidgets;

public class JLineTerminal {
    private static final String TERMINAL_NAME = "Aspectran JLine terminal";
    private final Terminal terminal;
    private final LineReader reader;
    private final LineReader commandReader;
    private final CommandCompleter commandCompleter;
    private final CommandHighlighter commandHighlighter;
    private final History commandHistory;
    private final boolean dumb;
    private final boolean dumbColor;
    private Style style;

    public JLineTerminal(ShellConsole console) throws IOException {
        this(console, null);
    }

    public JLineTerminal(ShellConsole console, String encoding) throws IOException {
        this.terminal = TerminalBuilder.builder().name(TERMINAL_NAME).encoding(encoding).build();
        this.dumb = "dumb".equals(this.terminal.getType());
        this.dumbColor = "dumb-color".equals(this.terminal.getType());
        this.commandCompleter = new CommandCompleter(console);
        this.commandHighlighter = new CommandHighlighter(console);
        this.commandHistory = new DefaultHistory();
        this.commandReader = LineReaderBuilder.builder().completer((Completer)this.commandCompleter).highlighter((Highlighter)this.commandHighlighter).history(this.commandHistory).terminal(this.terminal).build();
        this.commandReader.setOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        this.commandReader.unsetOpt(LineReader.Option.INSERT_TAB);
        this.commandReader.unsetOpt(LineReader.Option.AUTO_FRESH_LINE);
        AutosuggestionWidgets autosuggestionWidgets = new AutosuggestionWidgets(this.commandReader);
        autosuggestionWidgets.enable();
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
        this.reader.setOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        this.reader.unsetOpt(LineReader.Option.INSERT_TAB);
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public Charset getEncoding() {
        return this.terminal.encoding();
    }

    protected boolean isDumb() {
        return this.dumb;
    }

    protected boolean isDumbColor() {
        return this.dumbColor;
    }

    protected boolean isNormal() {
        return !this.dumb && !this.dumbColor;
    }

    public LineReader getReader() {
        return this.reader;
    }

    public LineReader getCommandReader() {
        return this.commandReader;
    }

    public CommandCompleter getCommandCompleter() {
        return this.commandCompleter;
    }

    public CommandHighlighter getCommandHighlighter() {
        return this.commandHighlighter;
    }

    public void setCommandHistoryFile(String historyFile) {
        this.commandReader.setVariable("history-file", (Object)historyFile);
        this.commandHistory.attach(this.commandReader);
    }

    public List<String> getCommandHistory() {
        ArrayList<String> result = new ArrayList<String>(this.commandHistory.size());
        this.commandHistory.forEach(e -> result.add(e.line()));
        return result;
    }

    public void clearCommandHistory() {
        try {
            this.commandHistory.purge();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void clearScreen() {
        if (!this.isDumb()) {
            if (this.commandReader.isReading()) {
                this.commandReader.callWidget("clear-screen");
                this.commandReader.callWidget("redraw-line");
                this.commandReader.callWidget("redisplay");
            } else if (this.reader.isReading()) {
                this.reader.callWidget("clear-screen");
                this.reader.callWidget("redraw-line");
                this.reader.callWidget("redisplay");
            } else if (this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0])) {
                this.terminal.flush();
            }
        }
    }

    public void clearLine() {
        if (this.isNormal()) {
            if (this.reader.isReading()) {
                this.reader.callWidget("clear");
            } else {
                this.commandReader.callWidget("clear");
            }
        } else {
            this.getWriter().write("\r \r");
            this.getWriter().flush();
        }
    }

    public void redrawLine() {
        if (!this.isDumb()) {
            if (this.reader.isReading()) {
                this.reader.callWidget("redraw-line");
                this.reader.callWidget("redisplay");
            } else if (this.commandReader.isReading()) {
                this.commandReader.callWidget("redraw-line");
                this.commandReader.callWidget("redisplay");
            }
        }
    }

    public OutputStream getOutput() {
        return this.terminal.output();
    }

    public PrintWriter getWriter() {
        return this.terminal.writer();
    }

    public boolean isReading() {
        return this.commandReader.isReading() || this.reader.isReading();
    }

    public boolean hasStyle() {
        return this.style != null;
    }

    protected Style getStyle() {
        return this.style;
    }

    protected void setStyle(Style style) {
        this.style = style;
    }

    public void applyStyle(String ... styles) {
        this.setStyle(new Style(this.style, styles));
    }

    public String toAnsi(String str) {
        return this.toAnsi(str, this.getStyle());
    }

    protected String toAnsi(String str, Style style) {
        AttributedStyle attributedStyle = style != null ? style.getAttributedStyle() : null;
        return JLineTextStyler.parseAsString(attributedStyle, str, this.terminal);
    }

    public void write(String str) {
        this.getWriter().write(this.toAnsi(str));
    }

    public void writeLine() {
        this.getWriter().println();
        this.getWriter().flush();
    }

    public void writeAbove(String str) {
        if (this.getReader().isReading()) {
            this.getReader().printAbove(this.toAnsi(str));
        } else {
            this.getCommandReader().printAbove(this.toAnsi(str));
        }
    }

    public void flush() {
        this.getWriter().flush();
    }

    protected static class Style {
        private final AttributedStyle attributedStyle;

        protected Style(String ... styles) {
            this((Style)null, styles);
        }

        protected Style(Style defaultStyle, String ... styles) {
            this.attributedStyle = defaultStyle != null ? JLineTextStyler.style(defaultStyle.getAttributedStyle(), styles) : JLineTextStyler.style(styles);
        }

        public AttributedStyle getAttributedStyle() {
            return this.attributedStyle;
        }
    }
}

