/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.shell.jline.console.TextStyleTokenHandler;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Colors;

public class JLineTextStyler {
    private static final Logger logger = LoggerFactory.getLogger(JLineTextStyler.class);

    public static AttributedCharSequence parse(String input) {
        return JLineTextStyler.parse(input, null);
    }

    public static AttributedCharSequence parse(String input, final AttributedStyle defaultStyle) {
        if (input == null) {
            return AttributedString.EMPTY;
        }
        if (!input.contains("{{") || !input.contains("}}")) {
            return new AttributedString((CharSequence)input, defaultStyle);
        }
        final AttributedStringBuilder asb = new AttributedStringBuilder(input.length());
        if (defaultStyle != null) {
            asb.style(defaultStyle);
        }
        new TextStyleTokenHandler(){

            @Override
            public void character(char c) {
                asb.append(c);
            }

            @Override
            public void style(String ... styles) {
                asb.style(JLineTextStyler.style(asb.style(), defaultStyle, styles));
            }
        }.handle(input);
        return asb;
    }

    public static String parseAsString(String input, Terminal terminal) {
        return JLineTextStyler.parseAsString(null, input, terminal);
    }

    public static String parseAsString(AttributedStyle defaultStyle, String input, Terminal terminal) {
        return JLineTextStyler.parse(input, defaultStyle).toAnsi(terminal);
    }

    public static AttributedStyle style(String ... styles) {
        return JLineTextStyler.style(AttributedStyle.DEFAULT, styles);
    }

    public static AttributedStyle style(AttributedStyle baseStyle, String ... styles) {
        return JLineTextStyler.style(baseStyle, baseStyle, styles);
    }

    private static AttributedStyle style(@NonNull AttributedStyle baseStyle, @Nullable AttributedStyle defaultStyle, String ... styles) {
        if (defaultStyle == null) {
            defaultStyle = AttributedStyle.DEFAULT;
        }
        if (styles != null) {
            String[] stringArray = styles;
            int n = stringArray.length;
            block130: for (int i = 0; i < n; ++i) {
                String style;
                switch (style = stringArray[i]) {
                    case "reset": {
                        baseStyle = defaultStyle;
                        continue block130;
                    }
                    case "bold": {
                        baseStyle = baseStyle.bold();
                        continue block130;
                    }
                    case "faint": {
                        baseStyle = baseStyle.faint();
                        continue block130;
                    }
                    case "bold:off": {
                        baseStyle = baseStyle.boldOff().faintOff();
                        continue block130;
                    }
                    case "italic": {
                        baseStyle = baseStyle.italic();
                        continue block130;
                    }
                    case "italic:off": {
                        baseStyle = baseStyle.italicOff();
                        continue block130;
                    }
                    case "underline": {
                        baseStyle = baseStyle.underline();
                        continue block130;
                    }
                    case "underline:off": {
                        baseStyle = baseStyle.underlineOff();
                        continue block130;
                    }
                    case "blink": {
                        baseStyle = baseStyle.blink();
                        continue block130;
                    }
                    case "blink:off": {
                        baseStyle = baseStyle.blinkOff();
                        continue block130;
                    }
                    case "inverse": {
                        baseStyle = baseStyle.inverse();
                        continue block130;
                    }
                    case "inverse:off": {
                        baseStyle = baseStyle.inverseOff();
                        continue block130;
                    }
                    case "conceal": {
                        baseStyle = baseStyle.conceal();
                        continue block130;
                    }
                    case "conceal:off": {
                        baseStyle = baseStyle.concealOff();
                        continue block130;
                    }
                    case "crossedOut": {
                        baseStyle = baseStyle.crossedOut();
                        continue block130;
                    }
                    case "crossedOut:off": {
                        baseStyle = baseStyle.crossedOutOff();
                        continue block130;
                    }
                    case "black": 
                    case "BLACK": 
                    case "fg:black": 
                    case "fg:BLACK": {
                        baseStyle = baseStyle.foreground(0);
                        continue block130;
                    }
                    case "red": 
                    case "fg:red": {
                        baseStyle = baseStyle.foreground(1);
                        continue block130;
                    }
                    case "green": 
                    case "fg:green": {
                        baseStyle = baseStyle.foreground(2);
                        continue block130;
                    }
                    case "yellow": 
                    case "fg:yellow": {
                        baseStyle = baseStyle.foreground(3);
                        continue block130;
                    }
                    case "blue": 
                    case "fg:blue": {
                        baseStyle = baseStyle.foreground(4);
                        continue block130;
                    }
                    case "magenta": 
                    case "fg:magenta": {
                        baseStyle = baseStyle.foreground(5);
                        continue block130;
                    }
                    case "cyan": 
                    case "fg:cyan": {
                        baseStyle = baseStyle.foreground(6);
                        continue block130;
                    }
                    case "GRAY": 
                    case "fg:GRAY": {
                        baseStyle = baseStyle.foreground(7);
                        continue block130;
                    }
                    case "gray": 
                    case "fg:gray": {
                        baseStyle = baseStyle.foreground(8);
                        continue block130;
                    }
                    case "RED": 
                    case "fg:RED": {
                        baseStyle = baseStyle.foreground(9);
                        continue block130;
                    }
                    case "GREEN": 
                    case "fg:GREEN": {
                        baseStyle = baseStyle.foreground(10);
                        continue block130;
                    }
                    case "YELLOW": 
                    case "fg:YELLOW": {
                        baseStyle = baseStyle.foreground(11);
                        continue block130;
                    }
                    case "BLUE": 
                    case "fg:BLUE": {
                        baseStyle = baseStyle.foreground(12);
                        continue block130;
                    }
                    case "MAGENTA": 
                    case "fg:MAGENTA": {
                        baseStyle = baseStyle.foreground(13);
                        continue block130;
                    }
                    case "CYAN": 
                    case "fg:CYAN": {
                        baseStyle = baseStyle.foreground(14);
                        continue block130;
                    }
                    case "WHITE": 
                    case "white": 
                    case "fg:WHITE": 
                    case "fg:white": {
                        baseStyle = baseStyle.foreground(15);
                        continue block130;
                    }
                    case "bg:black": 
                    case "bg:BLACK": {
                        baseStyle = baseStyle.background(0);
                        continue block130;
                    }
                    case "bg:red": {
                        baseStyle = baseStyle.background(1);
                        continue block130;
                    }
                    case "bg:green": {
                        baseStyle = baseStyle.background(2);
                        continue block130;
                    }
                    case "bg:yellow": {
                        baseStyle = baseStyle.background(3);
                        continue block130;
                    }
                    case "bg:blue": {
                        baseStyle = baseStyle.background(4);
                        continue block130;
                    }
                    case "bg:magenta": {
                        baseStyle = baseStyle.background(5);
                        continue block130;
                    }
                    case "bg:cyan": {
                        baseStyle = baseStyle.background(6);
                        continue block130;
                    }
                    case "bg:GRAY": {
                        baseStyle = baseStyle.background(7);
                        continue block130;
                    }
                    case "bg:gray": {
                        baseStyle = baseStyle.background(8);
                        continue block130;
                    }
                    case "bg:RED": {
                        baseStyle = baseStyle.background(9);
                        continue block130;
                    }
                    case "bg:GREEN": {
                        baseStyle = baseStyle.background(10);
                        continue block130;
                    }
                    case "bg:YELLOW": {
                        baseStyle = baseStyle.background(11);
                        continue block130;
                    }
                    case "bg:BLUE": {
                        baseStyle = baseStyle.background(12);
                        continue block130;
                    }
                    case "bg:MAGENTA": {
                        baseStyle = baseStyle.background(13);
                        continue block130;
                    }
                    case "bg:CYAN": {
                        baseStyle = baseStyle.background(14);
                        continue block130;
                    }
                    case "bg:WHITE": 
                    case "bg:white": {
                        baseStyle = baseStyle.background(15);
                        continue block130;
                    }
                    default: {
                        int color = -1;
                        if (style.startsWith("bg:")) {
                            try {
                                color = Integer.parseInt(style.substring(3));
                            }
                            catch (NumberFormatException ignored) {
                                try {
                                    color = Colors.rgbColor((String)style.toLowerCase());
                                }
                                catch (Throwable e) {
                                    logger.warn("Unable to parse color from string \"" + style + "\"", e);
                                }
                            }
                            baseStyle = baseStyle.background(color);
                        } else {
                            try {
                                color = style.startsWith("fb:") ? Integer.parseInt(style.substring(3)) : Integer.parseInt(style);
                            }
                            catch (NumberFormatException ignored) {
                                try {
                                    color = Colors.rgbColor((String)style.toLowerCase());
                                }
                                catch (Throwable e) {
                                    logger.warn("Unable to parse color from string \"" + style + "\"", e);
                                }
                            }
                            baseStyle = baseStyle.foreground(color);
                        }
                        if (color != -1) continue block130;
                        logger.warn("Unknown color code \"" + style + "\"");
                    }
                }
            }
        }
        return baseStyle;
    }
}

