/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.shell.jline.console.JLineTerminal;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.PrintStream;

public class TerminalPrintStream
extends PrintStream {
    private final JLineTerminal jlineTerminal;
    private final boolean above;
    private final String[] styles;

    public TerminalPrintStream(JLineTerminal jlineTerminal) {
        this(jlineTerminal, false, null);
    }

    public TerminalPrintStream(JLineTerminal jlineTerminal, boolean above) {
        this(jlineTerminal, above, null);
    }

    public TerminalPrintStream(@NonNull JLineTerminal jlineTerminal, boolean above, String[] styles) {
        super(jlineTerminal.getOutput());
        this.jlineTerminal = jlineTerminal;
        this.above = above;
        this.styles = styles;
    }

    @Override
    public void write(@NonNull byte[] buf, int off, int len) {
        try {
            String str = new String(buf, off, len, this.jlineTerminal.getEncoding());
            if (this.above && (str = str.stripTrailing()).isBlank()) {
                return;
            }
            JLineTerminal.Style oldStyle = null;
            if (this.styles != null) {
                oldStyle = this.jlineTerminal.getStyle();
                this.jlineTerminal.applyStyle(this.styles);
            }
            if (this.above) {
                if (this.jlineTerminal.isNormal()) {
                    this.jlineTerminal.writeAbove(str);
                } else {
                    this.jlineTerminal.clearLine();
                    this.jlineTerminal.write(str);
                    this.jlineTerminal.writeLine();
                    if (this.jlineTerminal.isReading()) {
                        this.jlineTerminal.redrawLine();
                    }
                }
            } else {
                this.jlineTerminal.write(str);
            }
            if (this.styles != null && oldStyle != null) {
                this.jlineTerminal.setStyle(oldStyle);
            }
        }
        catch (Exception e) {
            super.write(buf, off, len);
        }
    }

    @Override
    public void flush() {
        this.jlineTerminal.flush();
    }
}

