/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.shell.jline.console.JLineTerminal;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.PrintWriter;

public class TerminalPrintWriter
extends PrintWriter {
    private final JLineTerminal jlineTerminal;

    public TerminalPrintWriter(@NonNull JLineTerminal jlineTerminal) {
        super(jlineTerminal.getWriter());
        this.jlineTerminal = jlineTerminal;
    }

    @Override
    public void write(int c) {
        String str = Character.toString(c);
        this.write(str, 0, str.length());
    }

    @Override
    public void write(@NonNull char[] buf, int off, int len) {
        try {
            String str = new String(buf, off, len);
            this.jlineTerminal.write(str);
        }
        catch (Exception e) {
            super.write(buf, off, len);
        }
    }

    @Override
    public void write(@NonNull String str, int off, int len) {
        try {
            if (str.length() != len) {
                str = str.substring(off, off + len);
            }
            this.jlineTerminal.write(str);
        }
        catch (Exception e) {
            super.write(str, off, len);
        }
    }
}

