/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.service;

import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.asel.token.TokenEvaluator;
import com.aspectran.core.context.asel.token.TokenParser;
import com.aspectran.core.context.config.AcceptableConfig;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.context.config.ShellConfig;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.core.service.DefaultCoreService;
import com.aspectran.core.service.RequestAcceptor;
import com.aspectran.shell.adapter.ShellSessionAdapter;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.ShellService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public abstract class AbstractShellService
extends DefaultCoreService
implements ShellService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractShellService.class);
    private final ShellConsole console;
    private SessionManager sessionManager;
    private SessionAgent sessionAgent;
    private boolean verbose;
    private String greetings;
    private Token[] greetingsTokens;

    AbstractShellService(ShellConsole console) {
        Assert.notNull((Object)console, "console must not be null");
        this.console = console;
    }

    @Override
    public void afterContextLoaded() throws Exception {
        super.afterContextLoaded();
        this.parseGreetings();
    }

    @Override
    public ShellConsole getConsole() {
        return this.console;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String getGreetings() {
        return this.greetings;
    }

    @Override
    public void setGreetings(String greetings) {
        this.greetings = greetings;
    }

    @Override
    public void printGreetings() {
        if (this.greetingsTokens != null) {
            TokenEvaluator evaluator = this.getDefaultActivity().getTokenEvaluator();
            String message = evaluator.evaluateAsString(this.greetingsTokens);
            if (this.console.isReading()) {
                this.console.clearLine();
            }
            this.console.writeLine(message);
        } else if (this.greetings != null) {
            if (this.console.isReading()) {
                this.console.clearLine();
            }
            this.console.writeLine(this.greetings);
        }
    }

    private void parseGreetings() {
        if (StringUtils.hasText(this.greetings)) {
            this.greetingsTokens = TokenParser.makeTokens(this.greetings, true);
            if (this.greetingsTokens != null) {
                try {
                    for (Token token : this.greetingsTokens) {
                        Token.resolveAlternativeValue(token, this.getServiceClassLoader());
                    }
                }
                catch (Exception e) {
                    this.greetingsTokens = null;
                    logger.error("Failed to parse greetings", e);
                }
            }
        }
    }

    @Override
    public void printHelp() {
        String description;
        if (this.isVerbose() && (description = this.getActivityContext().getDescription()) != null) {
            this.console.writeLine(description);
        }
    }

    @Override
    public SessionAdapter newSessionAdapter() {
        if (this.sessionAgent != null) {
            return new ShellSessionAdapter(this.sessionAgent);
        }
        return null;
    }

    protected void createSessionManager() {
        SessionManagerConfig sessionManagerConfig;
        Assert.state(this.sessionManager == null, "Session Manager is already exists for shell service");
        ShellConfig shellConfig = this.getAspectranConfig().getShellConfig();
        if (shellConfig != null && (sessionManagerConfig = shellConfig.getSessionManagerConfig()) != null && sessionManagerConfig.isEnabled()) {
            try {
                DefaultSessionManager sessionManager = new DefaultSessionManager();
                sessionManager.setActivityContext(this.getActivityContext());
                sessionManager.setSessionManagerConfig(sessionManagerConfig);
                sessionManager.initialize();
                this.sessionManager = sessionManager;
                this.sessionAgent = new SessionAgent(sessionManager.getSessionHandler());
            }
            catch (Exception e) {
                throw new CoreServiceException("Failed to create session manager for shell service", e);
            }
        }
    }

    protected void destroySessionManager() {
        if (this.sessionAgent != null) {
            this.sessionAgent.invalidate();
            this.sessionAgent = null;
        }
        if (this.sessionManager != null) {
            this.sessionManager.destroy();
            this.sessionManager = null;
        }
    }

    @Override
    public void restart(String message) throws Exception {
        if (StringUtils.hasText(message)) {
            this.console.setStyle(this.console.getDangerStyle());
            this.console.writeAbove(message);
            this.console.resetStyle();
        }
        if (!this.isBusy() && this.console.confirmRestart()) {
            try {
                super.restart(message);
            }
            catch (Exception e) {
                logger.error("Shell restart failed", e);
                this.console.setStyle(this.console.getDangerStyle());
                this.console.writeAbove("Shell restart failed!");
                this.console.resetStyle();
            }
            if (this.console.isReading()) {
                this.console.redrawLine();
            }
        }
    }

    @Override
    public boolean isBusy() {
        return this.console.isReading();
    }

    @Override
    protected void configure(@NonNull AspectranConfig aspectranConfig) {
        ShellConfig shellConfig = aspectranConfig.getShellConfig();
        if (shellConfig != null) {
            this.configure(shellConfig);
        }
        super.configure(aspectranConfig);
    }

    private void configure(@NonNull ShellConfig shellConfig) {
        this.setVerbose(shellConfig.isVerbose());
        this.setGreetings(shellConfig.getGreetings());
        AcceptableConfig acceptableConfig = shellConfig.getAcceptableConfig();
        if (acceptableConfig != null) {
            this.setRequestAcceptor(new RequestAcceptor(acceptableConfig));
        }
    }
}

