/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.CoreTranslet;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.shell.activity.ShellActivity;
import com.aspectran.shell.command.OutputRedirection;
import com.aspectran.shell.command.TransletCommandLine;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.AbstractShellService;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class DefaultShellService
extends AbstractShellService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultShellService.class);
    protected volatile long pauseTimeout = -1L;

    DefaultShellService(ShellConsole console) {
        super(console);
    }

    @Override
    public Translet translate(TransletCommandLine transletCommandLine) throws TransletNotFoundException {
        PrintWriter outputWriter;
        if (this.checkPaused()) {
            return null;
        }
        if (transletCommandLine == null) {
            throw new IllegalArgumentException("transletCommandLine must not be null");
        }
        if (!this.isAcceptable(transletCommandLine.getRequestName())) {
            this.getConsole().writeError("Unavailable translet: " + transletCommandLine.getRequestName());
            return null;
        }
        String requestName = transletCommandLine.getRequestName();
        MethodType requestMethod = transletCommandLine.getRequestMethod() != null ? transletCommandLine.getRequestMethod() : MethodType.GET;
        ParameterMap parameterMap = transletCommandLine.getParameterMap();
        boolean procedural = parameterMap.isEmpty();
        boolean verbose = this.isVerbose() || transletCommandLine.isVerbose();
        List<OutputRedirection> redirectionList = transletCommandLine.getLineParser().getRedirectionList();
        if (redirectionList != null) {
            try {
                outputWriter = OutputRedirection.determineOutputWriter(redirectionList, this.getConsole());
            }
            catch (Exception e) {
                this.getConsole().writeError("Invalid Output Redirection - " + e.getMessage());
                return null;
            }
        } else {
            outputWriter = null;
        }
        ShellActivity activity = new ShellActivity(this);
        activity.setProcedural(procedural);
        activity.setVerbose(verbose);
        activity.setRequestName(requestName);
        activity.setRequestMethod(requestMethod);
        activity.setParameterMap(parameterMap);
        activity.setOutputWriter(outputWriter);
        try {
            activity.prepare();
        }
        catch (TransletNotFoundException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("No translet mapped for " + String.valueOf((Object)requestMethod) + " " + requestName);
            }
            throw e;
        }
        catch (Exception e) {
            this.serviceError(activity, e);
        }
        if (activity.isAsync()) {
            this.asyncPerform(activity);
            return null;
        }
        return this.perform(activity);
    }

    private void asyncPerform(@NonNull ShellActivity activity) {
        try {
            activity.preProcedure();
        }
        catch (ActivityTerminatedException e) {
            return;
        }
        catch (Exception e) {
            this.serviceError(activity, e);
        }
        Runnable performable = () -> this.perform(activity);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(performable);
        if (activity.getTimeout() != null) {
            completableFuture.orTimeout(activity.getTimeout(), TimeUnit.MILLISECONDS);
        }
        completableFuture.exceptionally(throwable -> {
            if (!activity.isCommitted() && !activity.isExceptionRaised()) {
                activity.setRaisedException(new ActivityTerminatedException("Async Timeout"));
            } else {
                logger.error(throwable.getMessage(), (Throwable)throwable);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Translet perform(@NonNull ShellActivity activity) {
        CoreTranslet translet = null;
        try {
            activity.perform();
            translet = activity.getTranslet();
        }
        catch (ActivityTerminatedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (Exception e) {
            this.serviceError(activity, e);
        }
        finally {
            if (activity.getOutputWriter() != null) {
                try {
                    activity.getOutputWriter().close();
                }
                catch (IOException e) {}
            }
        }
        if (translet != null && activity.getOutputWriter() == null) {
            try {
                String result = translet.getResponseAdapter().getWriter().toString();
                if (StringUtils.hasLength(result)) {
                    if (activity.isAsync()) {
                        this.getConsole().clearLine();
                    }
                    this.getConsole().writeLine(result);
                    if (activity.isAsync()) {
                        this.getConsole().redrawLine();
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Failed to print activity result", e);
            }
        }
        return translet;
    }

    private void serviceError(@NonNull ShellActivity activity, Exception e) {
        this.getConsole().clearLine();
        this.getConsole().resetStyle();
        Throwable t = activity.getRaisedException() != null ? activity.getRaisedException() : e;
        Throwable cause = ExceptionUtils.getRootCause(t);
        throw new CoreServiceException("Error occurred while processing request: " + activity.getFullRequestName() + "; Cause: " + ExceptionUtils.getSimpleMessage(cause), t);
    }

    private boolean checkPaused() {
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (this.pauseTimeout == -1L) {
                    this.getConsole().writeLine(this.getServiceName() + " has been paused");
                } else {
                    long remains = this.pauseTimeout - System.currentTimeMillis();
                    if (remains > 0L) {
                        this.getConsole().writeLine(this.getServiceName() + " has been paused and will resume after " + remains + " ms");
                    } else {
                        this.getConsole().writeLine(this.getServiceName() + " has been paused and will soon resume");
                    }
                }
                return true;
            }
            this.pauseTimeout = 0L;
        }
        return false;
    }
}

