/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.service;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.service.CoreServiceHolder;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.shell.service.DefaultShellService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public class DefaultShellServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultShellServiceBuilder.class);

    @NonNull
    public static DefaultShellService build(AspectranConfig aspectranConfig, ShellConsole console) {
        Assert.notNull((Object)aspectranConfig, "aspectranConfig must not be null");
        DefaultShellService shellService = new DefaultShellService(console);
        shellService.configure(aspectranConfig);
        DefaultShellServiceBuilder.setServiceStateListener(shellService);
        return shellService;
    }

    private static void setServiceStateListener(final @NonNull DefaultShellService shellService) {
        shellService.setServiceStateListener(new ServiceStateListener(){

            @Override
            public void started() {
                CoreServiceHolder.hold(shellService);
                shellService.createSessionManager();
                shellService.pauseTimeout = 0L;
                shellService.getConsole().clearScreen();
                shellService.printGreetings();
                shellService.printHelp();
            }

            @Override
            public void stopped() {
                shellService.destroySessionManager();
                CoreServiceHolder.release(shellService);
            }

            @Override
            public void paused(long millis) {
                if (millis > 0L) {
                    shellService.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            @Override
            public void paused() {
                shellService.pauseTimeout = -1L;
            }

            @Override
            public void resumed() {
                shellService.pauseTimeout = 0L;
            }
        });
    }
}

