/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf;

import com.aspectran.core.support.i18n.message.MessageSource;
import com.aspectran.core.support.i18n.message.NoSuchMessageException;
import com.aspectran.utils.Assert;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;

public class AspectranMessageResolver
extends AbstractMessageResolver {
    private final MessageSource messageSource;
    private final StandardMessageResolver standardMessageResolver;

    public AspectranMessageResolver(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, "messageSource must not be null");
        this.messageSource = messageSource;
        this.standardMessageResolver = new StandardMessageResolver();
    }

    public String resolveMessage(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        Assert.notNull((Object)context, "context must not be null");
        Assert.notNull((Object)key, "key must not be null");
        try {
            return this.messageSource.getMessage(key, messageParameters, context.getLocale());
        }
        catch (NoSuchMessageException noSuchMessageException) {
            if (origin != null) {
                return this.standardMessageResolver.resolveMessage(context, origin, key, messageParameters, false, true, true);
            }
            return null;
        }
    }

    public String createAbsentMessageRepresentation(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        return this.standardMessageResolver.createAbsentMessageRepresentation(context, origin, key, messageParameters);
    }
}

