/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.component.template.engine.TemplateEngine;
import com.aspectran.core.component.template.engine.TemplateEngineProcessException;
import com.aspectran.thymeleaf.AspectranTemplateEngine;
import com.aspectran.thymeleaf.context.ActivityExpressionContext;
import com.aspectran.thymeleaf.context.ActivityExpressionContextFactory;
import com.aspectran.utils.Assert;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;

public class ThymeleafTemplateEngine
implements TemplateEngine {
    private final ITemplateEngine templateEngine;

    public ThymeleafTemplateEngine(AspectranTemplateEngine templateEngine) {
        Assert.notNull((Object)templateEngine, "templateEngine must not be null");
        this.templateEngine = templateEngine;
    }

    public ITemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Override
    public void process(String templateName, Activity activity) throws TemplateEngineProcessException {
        try {
            ThymeleafTemplateEngine.process(this.templateEngine, templateName, activity);
            activity.getResponseAdapter().getWriter().flush();
        }
        catch (Exception e) {
            throw new TemplateEngineProcessException(e);
        }
    }

    @Override
    public void process(String templateSource, String contentType, Activity activity) throws TemplateEngineProcessException {
        try {
            if (contentType == null) {
                contentType = activity.getResponseAdapter().getContentType();
            }
            Locale locale = activity.getRequestAdapter().getLocale();
            Writer writer = activity.getResponseAdapter().getWriter();
            IEngineConfiguration configuration = this.templateEngine.getConfiguration();
            ActivityExpressionContext context = ActivityExpressionContextFactory.create(activity, configuration, locale);
            TemplateSpec templateSpec = new TemplateSpec(templateSource, contentType);
            this.templateEngine.process(templateSpec, (IContext)context, writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new TemplateEngineProcessException(e);
        }
    }

    public static void process(ITemplateEngine templateEngine, String templateName, Activity activity) throws IOException {
        TemplateSpec templateSpec;
        Assert.notNull((Object)templateEngine, "templateEngine must not be null");
        Assert.notNull((Object)templateName, "templateName must not be null");
        Assert.notNull((Object)activity, "activity must not be null");
        String contentType = activity.getResponseAdapter().getContentType();
        Locale locale = activity.getRequestAdapter().getLocale();
        Writer writer = activity.getResponseAdapter().getWriter();
        IEngineConfiguration configuration = templateEngine.getConfiguration();
        ActivityExpressionContext context = ActivityExpressionContextFactory.create(activity, configuration, locale);
        if (templateName.contains("::")) {
            FragmentExpression fragmentExpression;
            IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            try {
                fragmentExpression = (FragmentExpression)parser.parseExpression((IExpressionContext)context, "~{" + templateName + "}");
            }
            catch (TemplateProcessingException e) {
                throw new IllegalArgumentException("Invalid template name specification: '" + templateName + "'");
            }
            FragmentExpression.ExecutedFragmentExpression fragment = FragmentExpression.createExecutedFragmentExpression((IExpressionContext)context, (FragmentExpression)fragmentExpression);
            String templateNameToUse = FragmentExpression.resolveTemplateName((FragmentExpression.ExecutedFragmentExpression)fragment);
            Set markupSelectors = FragmentExpression.resolveFragments((FragmentExpression.ExecutedFragmentExpression)fragment);
            Map nameFragmentParameters = fragment.getFragmentParameters();
            if (nameFragmentParameters != null && fragment.hasSyntheticParameters()) {
                throw new IllegalArgumentException("Parameters in a view specification must be named (non-synthetic): '" + templateName + "'");
            }
            templateSpec = new TemplateSpec(templateNameToUse, markupSelectors, contentType, nameFragmentParameters);
        } else {
            templateSpec = new TemplateSpec(templateName, contentType);
        }
        templateEngine.process(templateSpec, (IContext)context, writer);
    }
}

