/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.context;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.thymeleaf.context.ActivityEngineContext;
import com.aspectran.thymeleaf.context.CurrentActivityHolder;
import com.aspectran.thymeleaf.context.web.WebActivityEngineContext;
import com.aspectran.utils.Assert;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.Contexts;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.engine.TemplateData;

public class ActivityEngineContextFactory
implements IEngineContextFactory {
    public IEngineContext createEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        Activity activity;
        Assert.notNull((Object)context, "Context object cannot be null");
        if (context instanceof CurrentActivityHolder) {
            CurrentActivityHolder holder = (CurrentActivityHolder)context;
            activity = holder.getActivity();
        } else {
            activity = null;
        }
        Activity activity2 = activity;
        Assert.notNull((Object)activity2, "Activity object cannot be null");
        Map<String, Object> variables = Contexts.isWebContext((IContext)context) ? ActivityEngineContextFactory.toVariables(activity2.getProcessResult()) : activity2.getActivityData();
        Set variableNames = context.getVariableNames();
        if (variableNames != null && !variableNames.isEmpty()) {
            if (variables == null) {
                variables = new LinkedHashMap(variableNames.size() + 1, 1.0f);
            }
            for (String variableName : variableNames) {
                variables.put(variableName, context.getVariable(variableName));
            }
        }
        if (Contexts.isWebContext((IContext)context)) {
            IWebContext webContext = Contexts.asWebContext((IContext)context);
            return new WebActivityEngineContext(activity2, configuration, templateData, templateResolutionAttributes, webContext.getExchange(), webContext.getLocale(), variables);
        }
        return new ActivityEngineContext(activity2, configuration, templateData, templateResolutionAttributes, context.getLocale(), variables);
    }

    private static Map<String, Object> toVariables(ProcessResult processResult) {
        if (processResult != null) {
            LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
            for (ContentResult cr : processResult) {
                for (ActionResult ar : cr) {
                    if (ar.getActionId() == null) continue;
                    variables.put(ar.getActionId(), ar.getResultValue());
                }
            }
            return variables;
        }
        return null;
    }
}

