/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.context;

import com.aspectran.core.context.asel.ognl.OgnlSupport;
import com.aspectran.utils.annotation.jsr305.NonNull;
import ognl.ClassResolver;
import ognl.MemberAccess;
import ognl.OgnlContext;
import org.thymeleaf.expression.IExpressionObjects;

public final class UtilizedOgnlContext
extends OgnlContext {
    private final IExpressionObjects expressionObjects;

    public UtilizedOgnlContext(IExpressionObjects expressionObjects) {
        super((ClassResolver)OgnlSupport.CLASS_RESOLVER, null, (MemberAccess)OgnlSupport.MEMBER_ACCESS);
        this.expressionObjects = expressionObjects;
    }

    public boolean containsKey(Object key) {
        boolean exists = super.containsKey(key);
        if (!exists && this.expressionObjects.containsObject(key.toString())) {
            exists = true;
        }
        return exists;
    }

    public Object get(@NonNull Object key) {
        Object value = super.get(key);
        if (value == null && this.expressionObjects.containsObject(key.toString())) {
            value = this.expressionObjects.getObject(key.toString());
            super.put(key.toString(), value);
        }
        return value;
    }

    public Object put(String key, Object value) {
        if (this.expressionObjects.containsObject(key)) {
            throw new IllegalArgumentException("Cannot put entry with key \"" + key + "\" into Expression Objects wrapper map: key matches the name of one of the expression objects");
        }
        return super.put(key, value);
    }

    public Object remove(@NonNull Object key) {
        if (this.expressionObjects.containsObject(key.toString())) {
            throw new IllegalArgumentException("Cannot remove entry with key \"" + String.valueOf(key) + "\" from Expression Objects wrapper map: key matches the name of one of the expression objects");
        }
        return super.remove(key);
    }
}

