/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.context.web;

import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import jakarta.servlet.ServletContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.thymeleaf.web.servlet.IServletWebApplication;

public class WebActivityApplication
implements IServletWebApplication {
    private final ServletContext servletContext;

    WebActivityApplication(@NonNull ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Enumeration<String> getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public Object getAttributeValue(String name) {
        return this.servletContext.getAttribute(name);
    }

    public void setAttributeValue(String name, Object value) {
        this.servletContext.setAttribute(name, value);
    }

    public InputStream getResourceAsStream(String path) {
        Assert.notNull((Object)path, "Path cannot be null");
        return this.servletContext.getResourceAsStream(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        Assert.notNull((Object)path, "Path cannot be null");
        return this.servletContext.getResource(path);
    }

    public Object getNativeServletContextObject() {
        return this.servletContext;
    }
}

