/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.context.web;

import com.aspectran.core.activity.Activity;
import com.aspectran.thymeleaf.context.web.WebActivityApplication;
import com.aspectran.thymeleaf.context.web.WebActivityRequest;
import com.aspectran.thymeleaf.context.web.WebActivitySession;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.activity.WebActivity;
import java.security.Principal;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.web.IWebApplication;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.IWebRequest;
import org.thymeleaf.web.IWebSession;

public class WebActivityExchange
implements IWebExchange {
    private final Activity activity;
    private final WebActivityRequest request;
    private final WebActivitySession session;
    private final WebActivityApplication application;

    public WebActivityExchange(Activity activity, WebActivityRequest request, WebActivitySession session, WebActivityApplication application) {
        this.activity = activity;
        this.request = request;
        this.session = session;
        this.application = application;
    }

    public IWebRequest getRequest() {
        return this.request;
    }

    public IWebSession getSession() {
        return this.session;
    }

    public IWebApplication getApplication() {
        return this.application;
    }

    public Principal getPrincipal() {
        return this.activity.getRequestAdapter().getPrincipal();
    }

    public Locale getLocale() {
        return this.activity.getRequestAdapter().getLocale();
    }

    public String getContentType() {
        return this.activity.getResponseAdapter().getContentType();
    }

    public String getCharacterEncoding() {
        return this.activity.getResponseAdapter().getEncoding();
    }

    public boolean containsAttribute(String name) {
        return this.activity.getRequestAdapter().hasAttribute(name);
    }

    public int getAttributeCount() {
        return this.activity.getRequestAdapter().getAttributeMap().size();
    }

    public Set<String> getAllAttributeNames() {
        return Collections.unmodifiableSet(this.activity.getRequestAdapter().getAttributeNames());
    }

    public Map<String, Object> getAttributeMap() {
        return Collections.unmodifiableMap(this.activity.getRequestAdapter().getAttributeMap());
    }

    public Object getAttributeValue(String name) {
        return this.activity.getRequestAdapter().getAttribute(name);
    }

    public void setAttributeValue(String name, Object value) {
        this.activity.getRequestAdapter().setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.activity.getRequestAdapter().removeAttribute(name);
    }

    public String transformURL(String url) {
        return this.activity.getResponseAdapter().transformPath(url);
    }

    @NonNull
    public static WebActivityExchange buildExchange(Activity activity) {
        Assert.notNull((Object)activity, "activity must not be null");
        if (activity instanceof WebActivity) {
            WebActivity webActivity = (WebActivity)activity;
            WebActivityRequest request = new WebActivityRequest(webActivity.getRequestAdapter());
            WebActivitySession session = new WebActivitySession(webActivity.getSessionAdapter());
            WebActivityApplication application = new WebActivityApplication(webActivity.getRequest().getServletContext());
            return new WebActivityExchange(activity, request, session, application);
        }
        throw new IllegalArgumentException("activity must be WebActivity");
    }
}

