/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.context.web;

import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.web.IWebRequest;

public class WebActivityRequest
implements IWebRequest {
    private final RequestAdapter requestAdapter;

    WebActivityRequest(@NonNull RequestAdapter requestAdapter) {
        this.requestAdapter = requestAdapter;
    }

    public String getMethod() {
        return this.getHttpServletRequest().getMethod();
    }

    public String getScheme() {
        return this.getHttpServletRequest().getScheme();
    }

    public String getServerName() {
        return this.getHttpServletRequest().getServerName();
    }

    public Integer getServerPort() {
        return this.getHttpServletRequest().getServerPort();
    }

    public String getApplicationPath() {
        String contextPath = this.getHttpServletRequest().getContextPath();
        if (contextPath != null && contextPath.length() == 1 && contextPath.charAt(0) == '/') {
            contextPath = "";
        }
        return contextPath;
    }

    public String getPathWithinApplication() {
        String requestURI = this.getHttpServletRequest().getRequestURI();
        if (requestURI == null) {
            return null;
        }
        String applicationPath = this.getApplicationPath();
        if (StringUtils.isEmpty(applicationPath)) {
            return requestURI;
        }
        return requestURI.substring(applicationPath.length());
    }

    public String getQueryString() {
        return this.getHttpServletRequest().getQueryString();
    }

    public boolean containsHeader(String name) {
        return this.getHttpServletRequest().getHeader(name) != null;
    }

    public int getHeaderCount() {
        return this.requestAdapter.getHeaderMap().size();
    }

    public Set<String> getAllHeaderNames() {
        return this.requestAdapter.getHeaderNames();
    }

    public Map<String, String[]> getHeaderMap() {
        LinkedHashMap headerMap = new LinkedHashMap(10);
        this.requestAdapter.getHeaderMap().forEach((key, value) -> headerMap.put(key, value.toArray(new String[0])));
        return Collections.unmodifiableMap(headerMap);
    }

    public String[] getHeaderValues(String name) {
        List<String> values = this.requestAdapter.getHeaderValues(name);
        return values != null && !values.isEmpty() ? values.toArray(new String[0]) : null;
    }

    public boolean containsParameter(String name) {
        return this.requestAdapter.hasParameter(name);
    }

    public int getParameterCount() {
        return this.requestAdapter.getParameterMap().size();
    }

    public Set<String> getAllParameterNames() {
        Collection<String> names = this.requestAdapter.getParameterNames();
        if (names != null) {
            return Set.copyOf(this.requestAdapter.getParameterNames());
        }
        return Collections.emptySet();
    }

    public Map<String, String[]> getParameterMap() {
        return this.requestAdapter.getParameterMap();
    }

    public String[] getParameterValues(String name) {
        return this.requestAdapter.getParameterValues(name);
    }

    public boolean containsCookie(String name) {
        Assert.notNull((Object)name, "name cannot be null");
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies == null) {
            return false;
        }
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            return true;
        }
        return false;
    }

    public int getCookieCount() {
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        return cookies == null ? 0 : cookies.length;
    }

    public Set<String> getAllCookieNames() {
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> cookieNames = new LinkedHashSet<String>(3);
        for (Cookie cookie : cookies) {
            cookieNames.add(cookie.getName());
        }
        return Collections.unmodifiableSet(cookieNames);
    }

    public Map<String, String[]> getCookieMap() {
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String[]> cookieMap = new LinkedHashMap<String, String[]>(3);
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            String cookieValue = cookie.getValue();
            if (cookieMap.containsKey(cookieName)) {
                String[] currentCookieValues = (String[])cookieMap.get(cookieName);
                String[] newCookieValues = Arrays.copyOf(currentCookieValues, currentCookieValues.length + 1);
                newCookieValues[currentCookieValues.length] = cookieValue;
                cookieMap.put(cookieName, newCookieValues);
                continue;
            }
            cookieMap.put(cookieName, new String[]{cookieValue});
        }
        return Collections.unmodifiableMap(cookieMap);
    }

    public String[] getCookieValues(String name) {
        Assert.notNull((Object)name, "Name cannot be null");
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies == null) {
            return null;
        }
        String[] cookieValues = null;
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            if (!name.equals(cookieName)) continue;
            String cookieValue = cookie.getValue();
            if (cookieValues != null) {
                String[] newCookieValues = (String[])Arrays.copyOf(cookieValues, cookieValues.length + 1);
                newCookieValues[cookieValues.length] = cookieValue;
                cookieValues = newCookieValues;
                continue;
            }
            cookieValues = new String[]{cookieValue};
        }
        return cookieValues;
    }

    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.requestAdapter.getAdaptee();
    }
}

