/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.context.web;

import com.aspectran.core.adapter.SessionAdapter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.web.IWebSession;

public class WebActivitySession
implements IWebSession {
    private final SessionAdapter sessionAdapter;

    WebActivitySession(SessionAdapter sessionAdapter) {
        this.sessionAdapter = sessionAdapter;
    }

    public boolean exists() {
        return this.sessionAdapter.isValid();
    }

    public boolean containsAttribute(String name) {
        return this.sessionAdapter.getAttribute(name) != null;
    }

    public int getAttributeCount() {
        Enumeration<String> enumer = this.sessionAdapter.getAttributeNames();
        if (enumer == null) {
            return 0;
        }
        int count = 0;
        while (enumer.hasMoreElements()) {
            enumer.nextElement();
            ++count;
        }
        return count;
    }

    public Set<String> getAllAttributeNames() {
        Enumeration<String> enumer = this.sessionAdapter.getAttributeNames();
        if (enumer == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> attributeNames = new LinkedHashSet<String>(10);
        while (enumer.hasMoreElements()) {
            attributeNames.add(enumer.nextElement());
        }
        return Collections.unmodifiableSet(attributeNames);
    }

    public Map<String, Object> getAttributeMap() {
        Enumeration<String> enumer = this.sessionAdapter.getAttributeNames();
        if (enumer == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(10);
        while (enumer.hasMoreElements()) {
            String attributeName = enumer.nextElement();
            attributeMap.put(attributeName, this.getAttributeValue(attributeName));
        }
        return Collections.unmodifiableMap(attributeMap);
    }

    public Object getAttributeValue(String name) {
        return this.sessionAdapter.getAttribute(name);
    }

    public void setAttributeValue(String name, Object value) {
        this.sessionAdapter.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.sessionAdapter.removeAttribute(name);
    }
}

