/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.expression;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.asel.ExpressionParserException;
import com.aspectran.core.context.asel.TokenizedExpression;
import com.aspectran.core.context.asel.ognl.OgnlSupport;
import com.aspectran.thymeleaf.context.CurrentActivityHolder;
import com.aspectran.thymeleaf.context.UtilizedOgnlContext;
import com.aspectran.thymeleaf.expression.ExpressionCache;
import com.aspectran.thymeleaf.expression.OgnlContextPropertyAccessor;
import com.aspectran.thymeleaf.expression.OgnlShortcutExpression;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.IStandardVariableExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.standard.util.StandardExpressionUtils;

public class ASELVariableExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(ASELVariableExpressionEvaluator.class);
    private static final String EXPRESSION_CACHE_TYPE_OGNL = "asel";
    private final boolean applyOgnlShortcuts;

    public ASELVariableExpressionEvaluator(boolean applyOgnlShortcuts) {
        this.applyOgnlShortcuts = applyOgnlShortcuts;
        OgnlContextPropertyAccessor accessor = new OgnlContextPropertyAccessor();
        OgnlRuntime.setPropertyAccessor(IContext.class, (PropertyAccessor)accessor);
    }

    public Object evaluate(IExpressionContext context, IStandardVariableExpression expression, StandardExpressionExecutionContext exeContext) {
        return ASELVariableExpressionEvaluator.evaluate(context, expression, exeContext, this.applyOgnlShortcuts);
    }

    private static Object evaluate(IExpressionContext context, IStandardVariableExpression expression, StandardExpressionExecutionContext exeContext, boolean applyOgnlShortcuts) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][" + TemplateEngine.threadIndex() + "] AspectranEL expression: evaluating expression \"" + expression.getExpression() + "\" on target");
        }
        try {
            Object result;
            ITemplateContext root;
            ITemplateContext tc;
            Activity activity;
            String expressionStr = expression.getExpression();
            if (expressionStr == null) {
                throw new TemplateProcessingException("Expression content is null, which is not allowed");
            }
            if (context instanceof CurrentActivityHolder) {
                CurrentActivityHolder holder = (CurrentActivityHolder)context;
                activity = holder.getActivity();
            } else {
                activity = null;
            }
            Activity activity2 = activity;
            IEngineConfiguration configuration = context.getConfiguration();
            boolean useSelectionAsRoot = expression.getUseSelectionAsRoot();
            ComputedOgnlExpression parsedExpression = ASELVariableExpressionEvaluator.obtainComputedOgnlExpression(activity2, configuration, expression, expressionStr, exeContext, applyOgnlShortcuts);
            OgnlContext contextVariables = ASELVariableExpressionEvaluator.resolveContextVariables(context, exeContext, parsedExpression);
            ITemplateContext templateContext = context instanceof ITemplateContext ? (tc = (ITemplateContext)context) : null;
            Object object = root = useSelectionAsRoot && templateContext != null && templateContext.hasSelectionTarget() ? templateContext.getSelectionTarget() : templateContext;
            if (root != null) {
                contextVariables.setRoot((Object)root);
            }
            try {
                result = ASELVariableExpressionEvaluator.executeExpression(activity2, configuration, parsedExpression.expression, contextVariables);
            }
            catch (OgnlShortcutExpression.OGNLShortcutExpressionNotApplicableException notApplicable) {
                ASELVariableExpressionEvaluator.invalidateComputedOgnlExpression(configuration, expression, expressionStr);
                return ASELVariableExpressionEvaluator.evaluate(context, expression, exeContext, false);
            }
            if (exeContext.getPerformTypeConversion()) {
                IStandardConversionService conversionService = StandardExpressions.getConversionService((IEngineConfiguration)configuration);
                return conversionService.convert(context, result, String.class);
            }
            return result;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + expression.getExpression() + "\"", (Throwable)e);
        }
    }

    @NonNull
    private static OgnlContext resolveContextVariables(IExpressionContext context, StandardExpressionExecutionContext exeContext, @NonNull ComputedOgnlExpression parsedExpression) {
        OgnlContext contextVariables = parsedExpression.mightNeedExpressionObjects ? new UtilizedOgnlContext(context.getExpressionObjects()) : OgnlSupport.createDefaultContext();
        if (exeContext.getRestrictVariableAccess()) {
            contextVariables.put("%RESTRICT_REQUEST_PARAMETERS%", (Object)"%RESTRICT_REQUEST_PARAMETERS%");
        }
        return contextVariables;
    }

    private static ComputedOgnlExpression obtainComputedOgnlExpression(Activity activity, IEngineConfiguration configuration, IStandardVariableExpression expression, String expressionStr, @NonNull StandardExpressionExecutionContext exeContext, boolean applyOgnlShortcuts) throws ExpressionParserException {
        boolean doApplyOgnlShortcuts;
        boolean bl = doApplyOgnlShortcuts = applyOgnlShortcuts && !exeContext.getRestrictVariableAccess() && !exeContext.getRestrictInstantiationAndStatic();
        if (exeContext.getRestrictInstantiationAndStatic() && StandardExpressionUtils.containsOGNLInstantiationOrStaticOrParam((String)expressionStr)) {
            throw new TemplateProcessingException("Instantiation of new objects and access to static classes or parameters is forbidden in this context");
        }
        if (expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            Object cachedExpression = ve.getCachedExpression();
            if (cachedExpression instanceof ComputedOgnlExpression) {
                ComputedOgnlExpression coe = (ComputedOgnlExpression)cachedExpression;
                return coe;
            }
            cachedExpression = ASELVariableExpressionEvaluator.parseComputedOgnlExpression(activity, configuration, expressionStr, doApplyOgnlShortcuts);
            ve.setCachedExpression(cachedExpression);
            return (ComputedOgnlExpression)cachedExpression;
        }
        if (expression instanceof SelectionVariableExpression) {
            SelectionVariableExpression sve = (SelectionVariableExpression)expression;
            Object cachedExpression = sve.getCachedExpression();
            if (cachedExpression instanceof ComputedOgnlExpression) {
                ComputedOgnlExpression coe = (ComputedOgnlExpression)cachedExpression;
                return coe;
            }
            cachedExpression = ASELVariableExpressionEvaluator.parseComputedOgnlExpression(activity, configuration, expressionStr, doApplyOgnlShortcuts);
            sve.setCachedExpression(cachedExpression);
            return (ComputedOgnlExpression)cachedExpression;
        }
        return ASELVariableExpressionEvaluator.parseComputedOgnlExpression(activity, configuration, expressionStr, doApplyOgnlShortcuts);
    }

    @NonNull
    private static ComputedOgnlExpression parseComputedOgnlExpression(Activity activity, IEngineConfiguration configuration, String expressionStr, boolean applyOGNLShortcuts) throws ExpressionParserException {
        ComputedOgnlExpression parsedExpression = (ComputedOgnlExpression)ExpressionCache.getFromCache(configuration, expressionStr, EXPRESSION_CACHE_TYPE_OGNL);
        if (parsedExpression != null) {
            return parsedExpression;
        }
        parsedExpression = ASELVariableExpressionEvaluator.parseExpression(activity, expressionStr, applyOGNLShortcuts);
        ExpressionCache.putIntoCache(configuration, expressionStr, parsedExpression, EXPRESSION_CACHE_TYPE_OGNL);
        return parsedExpression;
    }

    private static void invalidateComputedOgnlExpression(IEngineConfiguration configuration, IStandardVariableExpression expression, String expressionStr) {
        if (expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            ve.setCachedExpression(null);
        } else if (expression instanceof SelectionVariableExpression) {
            SelectionVariableExpression ve = (SelectionVariableExpression)expression;
            ve.setCachedExpression(null);
        }
        ExpressionCache.removeFromCache(configuration, expressionStr, EXPRESSION_CACHE_TYPE_OGNL);
    }

    @NonNull
    private static ComputedOgnlExpression parseExpression(Activity activity, String expressionStr, boolean applyOgnlShortcuts) throws ExpressionParserException {
        Object parsedExpression;
        String[] expressions;
        if (applyOgnlShortcuts && (expressions = OgnlShortcutExpression.parse(expressionStr)) != null) {
            OgnlShortcutExpression ose = new OgnlShortcutExpression(expressions);
            boolean mightNeedExpressionObjects = StandardExpressionUtils.mightNeedExpressionObjects((String)expressionStr);
            return new ComputedOgnlExpression(ose, mightNeedExpressionObjects);
        }
        boolean mightNeedExpressionObjects = false;
        if (activity != null) {
            TokenizedExpression tokenizedExpression = new TokenizedExpression(expressionStr);
            String substitutedExpression = tokenizedExpression.getSubstitutedExpression();
            if (substitutedExpression != null) {
                mightNeedExpressionObjects = StandardExpressionUtils.mightNeedExpressionObjects((String)substitutedExpression);
            }
            parsedExpression = tokenizedExpression;
        } else {
            try {
                parsedExpression = Ognl.parseExpression((String)expressionStr);
            }
            catch (OgnlException e) {
                throw new ExpressionParserException(expressionStr, e);
            }
            mightNeedExpressionObjects = StandardExpressionUtils.mightNeedExpressionObjects((String)expressionStr);
        }
        return new ComputedOgnlExpression(parsedExpression, mightNeedExpressionObjects);
    }

    private static Object executeExpression(Activity activity, IEngineConfiguration configuration, Object parsedExpression, OgnlContext contextVariables) throws Exception {
        if (parsedExpression instanceof OgnlShortcutExpression) {
            OgnlShortcutExpression ose = (OgnlShortcutExpression)parsedExpression;
            return ose.evaluate(configuration, (Map<String, Object>)contextVariables, contextVariables.getRoot());
        }
        if (activity != null && parsedExpression instanceof TokenizedExpression) {
            TokenizedExpression te = (TokenizedExpression)parsedExpression;
            return te.evaluate(activity, contextVariables, contextVariables.getRoot());
        }
        return Ognl.getValue((Object)parsedExpression, (OgnlContext)contextVariables, (Object)contextVariables.getRoot());
    }

    public String toString() {
        return "AspectranEL";
    }

    private static class ComputedOgnlExpression {
        Object expression;
        boolean mightNeedExpressionObjects;

        ComputedOgnlExpression(Object expression, boolean mightNeedExpressionObjects) {
            this.expression = expression;
            this.mightNeedExpressionObjects = mightNeedExpressionObjects;
        }
    }
}

