/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.expression;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ArrayPropertyAccessor;
import ognl.EnumerationPropertyAccessor;
import ognl.IteratorPropertyAccessor;
import ognl.ListPropertyAccessor;
import ognl.MapPropertyAccessor;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.SetPropertyAccessor;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.ExpressionCacheKey;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IContext;
import org.thymeleaf.standard.expression.OGNLContextPropertyAccessor;

public class OgnlShortcutExpression {
    private static final String EXPRESSION_CACHE_TYPE_OGNL_SHORTCUT = "ognlsc";
    private static final Object[] NO_PARAMS = new Object[0];
    private final String[] expressionLevels;

    OgnlShortcutExpression(String[] expressionLevels) {
        this.expressionLevels = expressionLevels;
    }

    Object evaluate(@NonNull IEngineConfiguration configuration, Map<String, Object> context, Object root) throws Exception {
        ICacheManager cacheManager = configuration.getCacheManager();
        ICache expressionCache = cacheManager == null ? null : cacheManager.getExpressionCache();
        Object target = root;
        for (String propertyName : this.expressionLevels) {
            if (target == null) {
                throw new OgnlException("source is null for getProperty(null, \"" + propertyName + "\")");
            }
            Class targetClass = OgnlRuntime.getTargetClass((Object)target);
            PropertyAccessor ognlPropertyAccessor = OgnlRuntime.getPropertyAccessor((Class)targetClass);
            if (target instanceof Class) {
                target = OgnlShortcutExpression.getObjectProperty((ICache<ExpressionCacheKey, Object>)expressionCache, propertyName, target);
                continue;
            }
            if (OGNLContextPropertyAccessor.class.equals((Object)ognlPropertyAccessor.getClass())) {
                target = OgnlShortcutExpression.getContextProperty(propertyName, context, target);
                continue;
            }
            if (ObjectPropertyAccessor.class.equals((Object)ognlPropertyAccessor.getClass())) {
                target = OgnlShortcutExpression.getObjectProperty((ICache<ExpressionCacheKey, Object>)expressionCache, propertyName, target);
                continue;
            }
            if (MapPropertyAccessor.class.equals((Object)ognlPropertyAccessor.getClass())) {
                target = OgnlShortcutExpression.getMapProperty(propertyName, (Map)target);
                continue;
            }
            if (ListPropertyAccessor.class.equals((Object)ognlPropertyAccessor.getClass())) {
                target = OgnlShortcutExpression.getListProperty((ICache<ExpressionCacheKey, Object>)expressionCache, propertyName, (List)target);
                continue;
            }
            if (SetPropertyAccessor.class.equals((Object)ognlPropertyAccessor.getClass())) {
                target = OgnlShortcutExpression.getSetProperty((ICache<ExpressionCacheKey, Object>)expressionCache, propertyName, (Set)target);
                continue;
            }
            if (IteratorPropertyAccessor.class.equals((Object)ognlPropertyAccessor.getClass())) {
                target = OgnlShortcutExpression.getIteratorProperty((ICache<ExpressionCacheKey, Object>)expressionCache, propertyName, (Iterator)target);
                continue;
            }
            if (EnumerationPropertyAccessor.class.equals((Object)ognlPropertyAccessor.getClass())) {
                target = OgnlShortcutExpression.getEnumerationProperty((ICache<ExpressionCacheKey, Object>)expressionCache, propertyName, (Enumeration)target);
                continue;
            }
            if (ArrayPropertyAccessor.class.equals((Object)ognlPropertyAccessor.getClass())) {
                target = OgnlShortcutExpression.getArrayProperty((ICache<ExpressionCacheKey, Object>)expressionCache, propertyName, (Object[])target);
                continue;
            }
            throw new OGNLShortcutExpressionNotApplicableException();
        }
        return target;
    }

    private static Object getContextProperty(String propertyName, Map<String, Object> context, Object target) throws OgnlException {
        if ("param".equals(propertyName) && context != null && context.containsKey("%RESTRICT_REQUEST_PARAMETERS%")) {
            throw new OgnlException("Access to variable \"" + propertyName + "\" is forbidden in this context. Note some restrictions apply to variable access. For example, accessing request parameters is forbidden in preprocessing and unescaped expressions, and also in fragment inclusion specifications.");
        }
        return ((IContext)target).getVariable(propertyName);
    }

    private static Object getObjectProperty(ICache<ExpressionCacheKey, Object> expressionCache, String propertyName, Object target) {
        Class currClass = OgnlRuntime.getTargetClass((Object)target);
        ExpressionCacheKey cacheKey = OgnlShortcutExpression.computeMethodCacheKey(currClass, propertyName);
        Method readMethod = null;
        if (expressionCache != null) {
            readMethod = (Method)expressionCache.get((Object)cacheKey);
        }
        if (readMethod == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(currClass);
            }
            catch (IntrospectionException e) {
                throw new OGNLShortcutExpressionNotApplicableException();
            }
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null) {
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if (!propertyDescriptor.getName().equals(propertyName)) continue;
                    readMethod = propertyDescriptor.getReadMethod();
                    if (readMethod == null || expressionCache == null) break;
                    expressionCache.put((Object)cacheKey, (Object)readMethod);
                    break;
                }
            }
        }
        if (readMethod == null) {
            throw new OGNLShortcutExpressionNotApplicableException();
        }
        try {
            return readMethod.invoke(target, NO_PARAMS);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new OGNLShortcutExpressionNotApplicableException();
        }
    }

    private static Object getMapProperty(@NonNull String propertyName, Map<?, ?> map) {
        return switch (propertyName) {
            case "size" -> map.size();
            case "keys", "keySet" -> map.keySet();
            case "values" -> map.values();
            case "isEmpty" -> {
                if (map.isEmpty()) {
                    yield Boolean.TRUE;
                }
                yield Boolean.FALSE;
            }
            default -> map.get(propertyName);
        };
    }

    public static Object getListProperty(ICache<ExpressionCacheKey, Object> expressionCache, @NonNull String propertyName, List<?> list) {
        return switch (propertyName) {
            case "size" -> list.size();
            case "iterator" -> list.iterator();
            case "isEmpty", "empty" -> {
                if (list.isEmpty()) {
                    yield Boolean.TRUE;
                }
                yield Boolean.FALSE;
            }
            default -> OgnlShortcutExpression.getObjectProperty(expressionCache, propertyName, list);
        };
    }

    public static Object getArrayProperty(ICache<ExpressionCacheKey, Object> expressionCache, @NonNull String propertyName, Object[] array) {
        if (propertyName.equals("length")) {
            return Array.getLength(array);
        }
        return OgnlShortcutExpression.getObjectProperty(expressionCache, propertyName, array);
    }

    public static Object getEnumerationProperty(ICache<ExpressionCacheKey, Object> expressionCache, @NonNull String propertyName, Enumeration<?> enumeration) {
        return switch (propertyName) {
            case "next", "nextElement" -> enumeration.nextElement();
            case "hasNext", "hasMoreElements" -> {
                if (enumeration.hasMoreElements()) {
                    yield Boolean.TRUE;
                }
                yield Boolean.FALSE;
            }
            default -> OgnlShortcutExpression.getObjectProperty(expressionCache, propertyName, enumeration);
        };
    }

    public static Object getIteratorProperty(ICache<ExpressionCacheKey, Object> expressionCache, @NonNull String propertyName, Iterator<?> iterator) {
        return switch (propertyName) {
            case "next" -> iterator.next();
            case "hasNext" -> {
                if (iterator.hasNext()) {
                    yield Boolean.TRUE;
                }
                yield Boolean.FALSE;
            }
            default -> OgnlShortcutExpression.getObjectProperty(expressionCache, propertyName, iterator);
        };
    }

    public static Object getSetProperty(ICache<ExpressionCacheKey, Object> expressionCache, @NonNull String propertyName, Set<?> set) {
        return switch (propertyName) {
            case "size" -> set.size();
            case "iterator" -> set.iterator();
            case "isEmpty" -> {
                if (set.isEmpty()) {
                    yield Boolean.TRUE;
                }
                yield Boolean.FALSE;
            }
            default -> OgnlShortcutExpression.getObjectProperty(expressionCache, propertyName, set);
        };
    }

    static String[] parse(String expression) {
        return OgnlShortcutExpression.doParseExpr(expression, 0, 0, expression.length());
    }

    @Nullable
    private static String[] doParseExpr(String expression, int level, int offset, int len) {
        String[] result;
        int codepoint;
        int i;
        boolean firstChar = true;
        for (i = offset; i < len && (codepoint = Character.codePointAt(expression, i)) != 46; ++i) {
            if (firstChar) {
                if (!Character.isJavaIdentifierStart(codepoint)) {
                    return null;
                }
                firstChar = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(codepoint)) continue;
            return null;
        }
        if (i < len) {
            result = OgnlShortcutExpression.doParseExpr(expression, level + 1, i + 1, len);
            if (result == null) {
                return null;
            }
        } else {
            result = new String[level + 1];
        }
        result[level] = expression.substring(offset, i);
        if ("true".equalsIgnoreCase(result[level]) || "false".equalsIgnoreCase(result[level]) || "null".equalsIgnoreCase(result[level])) {
            return null;
        }
        return result;
    }

    @NonNull
    private static ExpressionCacheKey computeMethodCacheKey(@NonNull Class<?> targetClass, String propertyName) {
        return new ExpressionCacheKey(EXPRESSION_CACHE_TYPE_OGNL_SHORTCUT, targetClass.getName(), propertyName);
    }

    static class OGNLShortcutExpressionNotApplicableException
    extends RuntimeException {
        OGNLShortcutExpressionNotApplicableException() {
        }
    }
}

