/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.template;

import com.aspectran.utils.Assert;
import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class DefaultTemplateResolver
extends AbstractTemplateResolver {
    public static final TemplateMode DEFAULT_TEMPLATE_MODE = TemplateMode.HTML;
    private TemplateMode templateMode = DEFAULT_TEMPLATE_MODE;
    private String template = "";

    public TemplateMode getTemplateMode() {
        return this.templateMode;
    }

    public void setTemplateMode(TemplateMode templateMode) {
        Assert.notNull((Object)templateMode, "Cannot set a null template mode value");
        this.templateMode = templateMode;
    }

    public void setTemplateMode(String templateMode) {
        Assert.notNull((Object)templateMode, "Cannot set a null template mode value");
        this.templateMode = TemplateMode.parse((String)templateMode);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return new StringTemplateResource(template);
    }

    protected TemplateMode computeTemplateMode(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return this.templateMode;
    }

    protected ICacheEntryValidity computeValidity(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return AlwaysValidCacheEntryValidity.INSTANCE;
    }
}

