/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.template;

import com.aspectran.utils.Assert;
import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.cache.NonCacheableCacheEntryValidity;
import org.thymeleaf.cache.TTLCacheEntryValidity;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class StringTemplateResolver
extends AbstractTemplateResolver {
    public static final TemplateMode DEFAULT_TEMPLATE_MODE = TemplateMode.HTML;
    public static final boolean DEFAULT_CACHEABLE = false;
    public static final Long DEFAULT_CACHE_TTL_MS = null;
    private TemplateMode templateMode = DEFAULT_TEMPLATE_MODE;
    private boolean cacheable = false;
    private Long cacheTTLMs = DEFAULT_CACHE_TTL_MS;

    public TemplateMode getTemplateMode() {
        return this.templateMode;
    }

    public void setTemplateMode(TemplateMode templateMode) {
        Assert.notNull((Object)templateMode, "Cannot set a null template mode value");
        this.templateMode = templateMode;
    }

    public void setTemplateMode(String templateMode) {
        Assert.notNull((Object)templateMode, "Cannot set a null template mode value");
        this.templateMode = TemplateMode.parse((String)templateMode);
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public Long getCacheTTLMs() {
        return this.cacheTTLMs;
    }

    public void setCacheTTLMs(Long cacheTTLMs) {
        this.cacheTTLMs = cacheTTLMs;
    }

    public void setUseDecoupledLogic(boolean useDecoupledLogic) {
        if (useDecoupledLogic) {
            throw new ConfigurationException("The 'useDecoupledLogic' flag is not allowed for String template resolution");
        }
        super.setUseDecoupledLogic(useDecoupledLogic);
    }

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return new StringTemplateResource(template);
    }

    protected TemplateMode computeTemplateMode(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return this.templateMode;
    }

    protected ICacheEntryValidity computeValidity(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        if (this.isCacheable()) {
            if (this.cacheTTLMs != null) {
                return new TTLCacheEntryValidity(this.cacheTTLMs.longValue());
            }
            return AlwaysValidCacheEntryValidity.INSTANCE;
        }
        return NonCacheableCacheEntryValidity.INSTANCE;
    }
}

